<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_ui_fieldgroups;

use Drupal\ui_patterns_ui\ComponentFormDisplayInterface;
use Drupal\ui_patterns_ui\Entity\ComponentFormDisplay;

/**
 * Trait for plugins (sources and prop types) handling attributes.
 */
trait FieldGroupFormTrait {

  /**
   * Returns the current display.
   */
  protected function getDisplay():?ComponentFormDisplayInterface {
    $component_id = \Drupal::routeMatch()->getParameter('component_id');
    $form_mode_name = \Drupal::routeMatch()->getParameter('form_mode_name');
    return ComponentFormDisplay::loadByFormMode($component_id, $form_mode_name);
  }

  /**
   * Returns the current group.
   */
  public function getGroup(): mixed {
    $group_id = \Drupal::routeMatch()->getParameter('group_id');
    $groups = ui_patterns_ui_fieldgroups_info($this->getDisplay());
    return $groups[$group_id] ?? NULL;
  }

}
