<?php

namespace Drupal\ui_patterns_ui_fieldgroups\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\field_group\Form\FieldGroupAddForm as BaseFieldGroupAddForm;
use Drupal\ui_patterns_ui\Entity\ComponentFormDisplay;
use Drupal\ui_patterns_ui_fieldgroups\FieldGroupFormTrait;

/**
 * Provides a form for adding a fieldgroup to a bundle.
 */
class FieldGroupAddForm extends BaseFieldGroupAddForm {
  use FieldGroupFormTrait;

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, mixed $entity_type_id = NULL, mixed $bundle = NULL, mixed $context = NULL) {
    $group_id = $this->getRouteMatch()->getParameter('group_id');
    $this->context = 'form';
    if ($group_id !== NULL) {
      return $this->buildEditConfigurationForm($form, $form_state);
    }
    else {
      return parent::buildForm($form, $form_state, $entity_type_id, $bundle, 'form');
    }
  }

  /**
   * {@inheritdoc}
   */
  public function buildEditConfigurationForm(array &$form, FormStateInterface $form_state): array {
    $group = $this->getGroup();
    $manager = $this->fieldGroupFormatterPluginManager;
    $plugin = $manager->getInstance([
      'format_type' => $group->format_type,
      'configuration' => [
        'label' => $group->label,
        'settings' => $group->format_settings,
      ],
      'group' => $group,
    ]);
    $form['format_settings'] = [
      '#type' => 'container',
      '#tree' => TRUE,
    ];

    $form['format_settings'] += $plugin->settingsForm();

    $form['actions'] = ['#type' => 'actions'];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Update group'),
      '#button_type' => 'primary',
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $group_id = $this->getRouteMatch()->getParameter('group_id');
    $group_name = $group_id ?? $form_state->get('group_name');
    if ($form_state->get('step') == 'formatter') {
      $form_state->set('step', 'configuration');
      $form_state->set('group_label', $form_state->getValue('label'));
      $form_state->set('group_name', $form_state->getValue('group_name'));
      $form_state->set('group_formatter', $form_state->getValue('group_formatter'));
      $form_state->setRebuild();
    }
    else {

      if ($group_id === NULL) {
        $new_group = (object) [
          'group_name' => $group_name,
          'context' => 'form',
          'children' => [],
          'parent_name' => '',
          'weight' => 20,
          'format_type' => $form_state->get('group_formatter'),
          'region' => 'hidden',
        ];
      }
      else {
        $new_group = $this->getGroup();
      }

      $new_group->format_settings = $form_state->getValue('format_settings');
      $new_group->label = $new_group->format_settings['label'];
      unset($new_group->format_settings['label']);
      $new_group->format_settings += $this->fieldGroupFormatterPluginManager->getDefaultSettings($form_state->get('group_formatter'), $this->context);

      $data = (array) $new_group;
      unset($data['group_name'], $data['entity_type'], $data['bundle'], $data['mode'], $data['form'], $data['context']);
      $form_mode_name = $this->getRouteMatch()->getParameter('form_mode_name');
      $component_id = $this->getRouteMatch()->getParameter('component_id');
      $display = ComponentFormDisplay::loadByFormMode($component_id, $form_mode_name);
      $display->setThirdPartySetting('ui_patterns_ui_fieldgroups', $new_group->group_name, $data);
      $display->save();
      // Store new group information for any additional submit handlers.
      $groups_added = $form_state->get('groups_added');
      $groups_added['_add_new_group'] = $new_group->group_name;
      $this->messenger->addMessage($this->t('New group %label successfully created.', ['%label' => $new_group->label]));

      $form_state->setRedirectUrl($display->toUrl('edit-form'));
      $this->cacheBackend->invalidate('field_groups');

    }

  }

}
