<?php

namespace Drupal\ui_patterns_ui_fieldgroups\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\Routing\RouteProviderInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Theme\ComponentPluginManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides local action definitions for all component forms.
 */
class UiPatternsUiFieldgroupLocalAction extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs a UiPatternsUiLocalAction object.
   */
  public function __construct(protected RouteProviderInterface $routeProvider, protected ComponentPluginManager $componentPluginManager, protected EntityTypeManagerInterface $entityTypeManager) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('router.route_provider'),
      $container->get('plugin.manager.sdc'),
      $container->get('entity_type.manager'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $this->derivatives = [];

    /** @var \Drupal\ui_patterns_ui\Entity\ComponentFormDisplay[] $displays */
    $displays = $this->entityTypeManager->getStorage('component_form_display')->loadMultiple();
    foreach ($displays as $display) {
      $this->derivatives["component_form_display.{$display->getComponentId()}.fieldgroup.add"] = [
        'route_name' => "entity.component_form_display.add_group",
        'title' => $this->t('Add Fieldgroup'),
        'appears_on' => ["entity.component_form_display.{$display->getComponentId()}.edit_form"],
        'parameters' => [
          'form_mode_name' => $display->getFormModeName(),
          'component_id' => $display->getComponentId(),
        ],
      ];
    }

    foreach ($this->derivatives as &$entry) {
      $entry += $base_plugin_definition;
    }

    return $this->derivatives;
  }

}
