<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_settings\Plugin\UiPatterns\Source;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ui_patterns\Attribute\Source;
use Drupal\ui_patterns\SourcePluginPropValueWidget;

/**
 * Plugin implementation of the source.
 */
#[Source(
  id: 'color',
  label: new TranslatableMarkup('Color'),
  description: new TranslatableMarkup('Default colorpicker'),
  prop_types: ['color'],
  tags: ['widget']
)]
class ColorWidget extends SourcePluginPropValueWidget {

  /**
   * {@inheritdoc}
   */
  public function getPropValue(): string {
    return (string) parent::getPropValue();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $form = parent::settingsForm($form, $form_state);
    $form['value'] = [
      '#type' => 'color',
      '#title' => $this->t('Color selection'),
      '#default_value' => $this->getSetting('value'),
    ];
    $this->addRequired($form['value']);
    return $form;
  }

}
