<?php

namespace Drupal\ui_patterns_settings\Template;

use Drupal\Core\Template\Attribute;

/**
 * Collects, sanitizes, and renders HTML attributes.
 */
class AttributesSet {

  /**
   * Constructs a \Drupal\ui_patterns_settings\Template\Style object.
   *
   * @param array $attributesSetConfig
   *   An array of styles configuration to be converted.
   * @param array $attributesSet
   *   An associative array of key-value pairs of selected subset.
   */
  public function __construct(protected array $attributesSetConfig = [], protected array $attributesSet = []) {
  }

  /**
   * Converts style object to an array of attributes.
   */
  public function toAttributes(): array {
    $classes_map = $this->toClasses();
    $attributes_map = [];
    foreach ($classes_map as $prop_id => $class) {
      $attributes_map[$prop_id] = new Attribute(['class' => $class]);
    }
    return $attributes_map;
  }

  /**
   * Converts style object to an array of classes.
   */
  public function toClasses(): array {
    $style_set = $this->attributesSet;
    $classes_map = [];
    if (is_array($this->attributesSetConfig['default'])) {
      foreach ($this->attributesSetConfig['default'] as $default_key => $default_value) {
        $classes_map[$default_key] = $default_value;
      }
    }
    foreach ($style_set as $style_set_id => $value) {
      if (isset($this->attributesSetConfig[$style_set_id][$value])) {
        if (is_array($this->attributesSetConfig[$style_set_id][$value])) {
          foreach ($this->attributesSetConfig[$style_set_id][$value] as $style_key => $style_value) {
            $classes_map[$style_key] = $style_value;
          }
        }
        else {
          $classes_map[$style_set_id] = $this->attributesSetConfig[$style_set_id][$value];
        }

      }
    }
    return $classes_map;
  }

}
