<?php

declare(strict_types=1);

namespace Drupal\Tests\ui_patterns_settings\Unit\Template;

use Drupal\Component\Serialization\Yaml;
use Drupal\Tests\UnitTestCase;
use Drupal\ui_patterns_settings\Template\AttributesSet;

/**
 * @coversDefaultClass \Drupal\ui_patterns_settings\Template\AttributesSet
 *
 * @group ui_patterns_settings
 */
final class AttributesSetTest extends UnitTestCase {

  /**
   * Test the method ::toClasses().
   *
   * @dataProvider provideStyleData
   */
  public function testAttributesSet(array $style, array $input, array $expected): void {
    $classes_map = (new AttributesSet($style, $input))->toClasses();
    $this->assertEquals($expected, $classes_map);
  }

  /**
   * Provide data for provideStyleData.
   */
  public static function provideStyleData(): array {
    $file_contents = file_get_contents(__DIR__ . "/../../../fixtures/AttributesSetDataSet.yml");
    $data = $file_contents ? Yaml::decode($file_contents) : [];
    $result = [];
    foreach ($data['expected'] as $expected) {
      $result[] = [$data['style'], $expected['input'], $expected['output']];
    }
    return $result;
  }

}
