<?php

namespace Drupal\ui_patterns_ui_fieldgroups\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\ui_patterns_ui_fieldgroups\FieldGroupFormTrait;

/**
 * Provides a form for removing a fieldgroup from a component.
 */
class FieldGroupDeleteForm extends ConfirmFormBase {
  use FieldGroupFormTrait;

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->getDisplay()->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $display = $this->getDisplay();
    $group_id = $this->getRouteMatch()->getParameter('group_id');
    $display->unsetThirdPartySetting('ui_patterns_ui_fieldgroups', $group_id);
    $display->removePropSlotOption($group_id);
    foreach ($display->getPropSlotOptions() as $prop_id => $options) {
      if (is_array($options) && $options['parent'] === $group_id) {
        $options['parent'] = '';
        $display->setPropSlotOptions($prop_id, $options);
      }
    }
    $display->save();
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    $group = $this->getGroup();
    return $this->t('Are you sure you want to delete the group %group?', ['%group' => $group->label ?? '']);
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ui_patterns_ui_fieldgroups_delete_form';
  }

}
