<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_settings\Plugin\UiPatterns\PropType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ui_patterns\Attribute\PropType;
use Drupal\ui_patterns\PropTypeConversionTrait;
use Drupal\ui_patterns\PropTypePluginBase;

/**
 * Provides a 'color' PropType.
 */
#[PropType(
  id: 'color',
  label: new TranslatableMarkup('Color'),
  description: new TranslatableMarkup('Hexadecimal color with optional transparency.'),
  default_source: 'color',
  schema: [
    'type' => 'string',
    'pattern' => '^#(([0-9a-fA-F]{3}){1,2}|[0-9a-fA-F]{6}[0-9a-fA-F]{2}?)$',
  ],
  priority: 1,
  typed_data: ['string']
)]
class ColorPropType extends PropTypePluginBase {

  use PropTypeConversionTrait;

  /**
   * {@inheritdoc}
   */
  public static function normalize(mixed $value, ?array $definition = NULL): string {
    return static::convertToString($value);
  }

}
