<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_settings\Plugin\UiPatterns\Source;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ui_patterns\Attribute\Source;
use Drupal\ui_patterns\SourcePluginPropValueWidget;

/**
 * Plugin implementation of the source.
 */
#[Source(
  id: 'coloris',
  label: new TranslatableMarkup('Coloris'),
  description: new TranslatableMarkup('Coloris color selector'),
  prop_types: ['color'],
  tags: ['widget']
)]
class ColorisWidget extends SourcePluginPropValueWidget {

  /**
   * {@inheritdoc}
   */
  public function getPropValue(): string {
    return (string) parent::getPropValue();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $form = parent::settingsForm($form, $form_state);
    if (!$this->moduleHandler->moduleExists('coloris')) {
      $form['warning'] = [
        '#theme' => 'status_messages',
        '#message_list' => [
          'error' => [
            $this->t('You need to enable the Coloris module to use this source.'),
          ],
        ],
      ];
      return $form;
    }

    $form['value'] = [
      '#type' => 'coloriswidget',
      '#title' => $this->t('Color selection'),
      '#default_value' => $this->getSetting('value'),
      '#swatches' => $this->propDefinition['swatches'] ?? [],
    ];
    $this->addRequired($form['value']);
    return $form;
  }

}
