<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_settings\Plugin\UiPatterns\Source;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ui_patterns\Attribute\Source;
use Drupal\ui_patterns\EnumTrait;
use Drupal\ui_patterns\Plugin\UiPatterns\Source\SelectWidget;
use Drupal\ui_patterns_settings\CSSWidgetTrait;

/**
 * Enum CSS widget source.
 */
#[Source(
  id: 'enum_widget',
  label: new TranslatableMarkup('Enum CSS widget'),
  description: new TranslatableMarkup('Display enums as grid / colors / etc.'),
  prop_types: ['enum', 'variant'],
  tags: ['widget']
)]
class EnumWidget extends SelectWidget {

  use EnumTrait;
  use CSSWidgetTrait;

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $form = parent::settingsForm($form, $form_state);
    $form['value'] = $this->cssSettingsForm($form['value'], $this->widgetSettings);
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function widgetSettingsForm(array $form, FormStateInterface $form_state): array {
    $form = parent::widgetSettingsForm($form, $form_state);
    $options = self::getEnumOptions($this->getPropDefinition());
    return $this->cssWidgetSettingsForm($form, $this->widgetSettings, $options);
  }

}
