<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_settings\Template;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Twig extension providing UI Patterns-settings functionalities.
 *
 * @package Drupal\ui_patterns_settings\Template
 */
class TwigExtension extends AbstractExtension {

  /**
   * {@inheritdoc}
   */
  public function getName(): string {
    return 'ui_patterns_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction('create_attributes_set', [$this, 'createAttributesSet']),
    ];
  }

  /**
   * Create style attribute.
   *
   * @param array $styles
   *   The style config.
   * @param array $style_set
   *   The style set config.
   *
   * @return array
   *   An associative array keyed by the style name.
   */
  public function createAttributesSet(array $styles, array $style_set): array {
    return (new AttributesSet($styles, $style_set))->toAttributes();
  }

}
