# Out of scope

Here is a list of Bootstrap features that are not intended to be implemented
because either:

- it is rarely used
- it is redundant with other existing features

You can implement it in your own sub-themes if needed, or you can still open
issues and provide MR to add support.


## Features


### Layouts

#### Columns

- [Column breaks](https://getbootstrap.com/docs/5.2/layout/columns/#column-breaks)
- [Margin utilities](https://getbootstrap.com/docs/5.2/layout/columns/#margin-utilities):
  Responsive variations have not been added in the styles.

#### CSS Grid

[Bootstrap documentation](https://getbootstrap.com/docs/5.3/layout/css-grid/)

[Drupal.org issue](https://www.drupal.org/project/ui_suite_bootstrap/issues/3292505):
Not enabled by default in Bootstrap and potential conflict with default grid system.

### Forms

- [Toggle buttons](https://getbootstrap.com/docs/5.3/forms/checks-radios/#toggle-buttons)
- [Multiple inputs](https://getbootstrap.com/docs/5.3/forms/input-group/#multiple-inputs)
- [Buttons with dropdowns](https://getbootstrap.com/docs/5.3/forms/input-group/#buttons-with-dropdowns)
- [Segmented buttons](https://getbootstrap.com/docs/5.3/forms/input-group/#segmented-buttons)
- [Custom styles](https://getbootstrap.com/docs/5.3/forms/validation/#custom-styles)

### Components

- [Placeholders](https://getbootstrap.com/docs/5.3/components/placeholders/)
- [Popovers](https://getbootstrap.com/docs/5.3/components/popovers/)
- [Scrollspy](https://getbootstrap.com/docs/5.3/components/scrollspy/)
- [Tooltips](https://getbootstrap.com/docs/5.3/components/tooltips/)

### Helpers

#### Stacks

[Bootstrap documentation](https://getbootstrap.com/docs/5.3/helpers/stacks/)

[Drupal.org issue](https://www.drupal.org/project/ui_suite_bootstrap/issues/3292606):
The matching styles will not be added.

### Utilities

#### Borders

[Sizes](https://getbootstrap.com/docs/5.3/utilities/borders/#sizes):
Combinations like `rounded-{position}-{size|style}` have not been added.

#### Flex

[Flex](https://getbootstrap.com/docs/5.3/utilities/flex/):
Responsive variations have not been added in the styles.

#### Float

[Float](https://getbootstrap.com/docs/5.3/utilities/float/):
Responsive variations have not been added in the styles.

#### Object fit

[Object fit](https://getbootstrap.com/docs/5.3/utilities/object-fit/):
Responsive variations have not been added in the styles.

#### Spacing

[Spacing](https://getbootstrap.com/docs/5.3/utilities/spacing/):
Responsive variations have not been added in the styles.
