# UI Suite DSFR

This Theme is meant to be used for building websites affiliated with the French government only, [**see this page**](https://www.systeme-de-design.gouv.fr/version-courante/fr/premiers-pas/perimetre-d-application).
A [French version](#version-française) is provided, in addition to the [English documentation](#english-version).

---

## Version Française

### Introduction

Ui Suite DSFR est la solution Drupal pour implémenter le DSFR, le Design System de l'État français 🇫🇷. Ce thème implémente les composants, styles et icônes du DSFR. Notre solution est [**recommandée par le Service d'Information du Gouvernement (SIG)**](https://www.systeme-de-design.gouv.fr/version-courante/fr/communaute/portages-du-dsfr#drupal) et assure la conformité de l'interface utilisateur avec les standards de la marque de l'État. Ui Suite DSFR est utilisée dans de nombreuses administrations et est populaire auprès des agences Drupal.

### Installation du DSFR

La librairie DSFR doit être installée de façon à ce que le fichier suivant `/libraries/dsfr/dist/dsfr.module.js` existe bien par rapport au répertoire racine de votre projet Drupal.
Nous proposons plusieurs méthodes ci-dessous à titre d'exemple.

#### Méthode 1 : Installation via Composer

Vous pouvez utiliser Composer pour télécharger automatiquement la librairie DSFR et la placer au bon endroit. Plusieurs options sont possibles via composer. Nous montrons ici deux possibilités.

##### Option A : Avec un dépôt de paquets Composer

Ajoutez un dépôt personnalisé à votre fichier ‘composer.json’ et configurez le paquet ‘gouvernementfr/dsfr’.

Exemple :

```json
{
  "require": {
    "gouvernementfr/dsfr": "1.14.1",
    "composer/installers": "^2"
  },
  "repositories": {
    "dsfr": {
      "type": "package",
      "package": {
        "name": "gouvernementfr/dsfr",
        "type": "drupal-library",
        "version": "1.14.1",
        "dist": {
          "type": "zip",
          "url": "https://github.com/GouvernementFR/dsfr/releases/download/v1.14.1/dsfr-v1.14.1.zip"
        }
      }
    }
  },
  "extra": {
    "installer-paths": {
      "web/core": ["type:drupal-core"],
      "web/libraries/{$name}": ["type:drupal-library"]
    }
  }
}
```

##### Option B : En utilisant Asset Packagist

Si vous utilisez le site [Asset Packagist](https://asset-packagist.org), vous pouvez télécharger le paquet `npm-asset/gouvfr--dsfr`. L'exemple ci-dessous montre comment configurer votre `composer.json`.
Dans notre exemple, `web` est le répertoire racine Drupal (voir la règle sur le type de paquet `drupal-core`).
Le projet `oomphinc/composer-installers-extender` est utilisé pour relocaliser le paquet `npm-asset/gouvfr--dsfr`.
Pour que cette méthode fonctionne, il faut :

1. Autoriser le plugin `oomphinc/composer-installers-extender` dans la section `extra.config.allow-plugins`.
2. Déclarer le type de paquet `npm-asset` dans `extra.installer-types`.
3. Définir le chemin de destination pour le paquet `npm-asset/gouvfr--dsfr` dans `extra.installer-paths`.

```json
{
  "require": {
    "npm-asset/gouvfr--dsfr": "1.14.1",
    "composer/installers": "^2",
    "oomphinc/composer-installers-extender": "^2"
  },
  "repositories": {
    "asset-packagist": {
      "type": "composer",
      "url": "https://asset-packagist.org"
    }
  },
  "extra": {
    "config": {
      "allow-plugins": {
        "composer/installers": true,
        "oomphinc/composer-installers-extender": true
      }
    },
    "installer-types": ["npm-asset"],
    "installer-paths": {
      "web/core": ["type:drupal-core"],
      "web/libraries/dsfr": ["npm-asset/gouvfr--dsfr"]
    }
  }
}
```

#### Méthode 2 : Installation manuelle

Téléchargez la bibliothèque DSFR dans le dossier `libraries/dsfr` de votre projet.

---

## English Version

Ui Suite DSFR is the Drupal solution for implementing the **DSFR**, the French government's Design System 🇫🇷. This theme implements the components, styles, and icons of the DSFR. Our solution is [**recommended by the Government's Public Communication Service (SIG)**](https://www.systeme-de-design.gouv.fr/version-courante/fr/communaute/portages-du-dsfr#drupal) and ensures the user interface's compliance with government standards. It's used in many government administrations and is popular with Drupal agencies.

### DSFR Installation

Regardless of the method you choose, the DSFR library must be installed so that the file `/libraries/dsfr/dist/dsfr.module.js` exists relative to your Drupal project's root directory.

---

#### Method 1: Installation via Composer

You can use Composer to automatically download the DSFR library in the right location. There are several possible options. Here we show two possibilities; feel free to choose whichever suits you.

---

##### Option A: With a Composer Package Repository

Add a custom repository to your `composer.json` file and configure the `gouvernementfr/dsfr` package.

```json
{
  "require": {
    "gouvernementfr/dsfr": "1.14.1",
    "composer/installers": "^2"
  },
  "repositories": {
    "dsfr": {
      "type": "package",
      "package": {
        "name": "gouvernementfr/dsfr",
        "type": "drupal-library",
        "version": "1.14.1",
        "dist": {
          "type": "zip",
          "url": "https://github.com/GouvernementFR/dsfr/releases/download/v1.14.1/dsfr-v1.14.1.zip"
        }
      }
    }
  },
  "extra": {
    "installer-paths": {
      "web/core": ["type:drupal-core"],
      "web/libraries/{$name}": ["type:drupal-library"]
    }
  }
}
```

##### Option B : Using the composer repository 'Asset Packagist'

If you are using the website [Asset Packagist](https://asset-packagist.org), the package `npm-asset/gouvfr--dsfr` can be
downloaded from this repository. The `composer.json` of your Drupal project can be like below.
In the example, `web` is the Drupal root directory (see the rule on package type `drupal-core`).
The project `oomphinc/composer-installers-extender` is used to relocate the package `npm-asset/gouvfr--dsfr`.
The relocation requires that:

- the composer plugin `oomphinc/composer-installers-extender` is allowed in section `extra.config.allow-plugins`;
- the package type `npm-asset` is declared in the `extra.installer-types` section;
- the target directory for the package `npm-asset/gouvfr--dsfr` is declared in the `extra.installer-paths` section.

```json
{
  "require": {
    "npm-asset/gouvfr--dsfr": "1.14.1",
    "composer/installers": "^2",
    "oomphinc/composer-installers-extender": "^2"
  },
  "repositories": {
    "asset-packagist": {
      "type": "composer",
      "url": "https://asset-packagist.org"
    }
  },
  "extra": {
    "config": {
      "allow-plugins": {
        "composer/installers": true,
        "oomphinc/composer-installers-extender": true
      }
    },
    "installer-types": ["npm-asset"],
    "installer-paths": {
      "web/core": ["type:drupal-core"],
      "web/libraries/dsfr": ["npm-asset/gouvfr--dsfr"]
    }
  }
}
```

#### Method 2: Manual Installation

Download the DSFR library in the `libraries/dsfr` folder of your project.
