<?php
function ulogin_callback() {
  if (!empty($_POST['token']) || !empty($_GET['token'])) {
    $token = !empty($_POST['token']) ? $_POST['token'] : $_GET['token'];
    $data_raw = drupal_http_request('http://ulogin.ru/token.php?token=' . $token . '&host=' . $_SERVER['HTTP_HOST']);
    if (!empty($data_raw->error)) {
      watchdog('ulogin', print_r($data_raw, 1), array(), WATCHDOG_WARNING);
      drupal_set_message($data_raw->error, 'error');
      return MENU_ACCESS_DENIED;
    }

    $data = json_decode($data_raw->data, TRUE);
    //check for error
    if (!empty($data['error'])) {
      watchdog('ulogin', print_r($data, 1), array(), WATCHDOG_WARNING);
      drupal_set_message($data['error'], 'error');
      return MENU_ACCESS_DENIED;
    }
    //validate that returned data contains 'network' and 'uid' keys
    if (empty($data['network']) || empty($data['uid'])) {
      watchdog('ulogin', print_r($data, 1), array(), WATCHDOG_WARNING);
      drupal_set_message('something is wrong, try again later', 'error');
      return MENU_ACCESS_DENIED;
    }
    //remove 'access_token' property
    unset($data['access_token']);
  }
  else {
    drupal_set_message('no token given', 'error');
    return MENU_ACCESS_DENIED;
  }
  
  global $user;
  //user is already logged in, tries to add new identity
  if (user_is_logged_in()) {
    //identity is already registered
    if ($identity = _ulogin_identity_load($data)) {
      //registered to this user
      if ($user->uid == $identity['uid']) {
        drupal_set_message(t('You have already registered this identity.'));
        $destination = drupal_substr(drupal_get_destination(), 12);
        drupal_goto($destination);
      }
      //registered to another user
      else {
        drupal_set_message(t('This identity is registered to another user.'), 'error');
        $destination = drupal_substr(drupal_get_destination(), 12);
        drupal_goto($destination);
      }
    }
    //identity is not registered - register it to the logged in user
    else {
      _ulogin_identity_save($data);
      drupal_set_message(t('New identity added.'));
      $destination = drupal_substr(drupal_get_destination(), 12);
      drupal_goto($destination);
    }
  }
  
  if ($identity = _ulogin_identity_load($data)) {
    //check if user is blocked
    if (_ulogin_user_is_blocked_by_uid($identity['uid'])) {
      drupal_set_message(t('Your account has not been activated or is blocked.'), 'error');
    }
    else {
      user_external_login(user_load($identity['uid']));
    }
  }
  //handle duplicate email addresses
  elseif (variable_get('ulogin_duplicate_emails', 1) && !empty($data['email']) && $account = user_load(array('mail' => $data['email']))) {
    drupal_set_message(t('You are trying to login with email address of another user.'), 'error');
    if (!empty($account->ulogin)) {
      $providers = _ulogin_providers_list();
      drupal_set_message(t('If you are completely sure it is your email address, try to login through %network.', array('%network' => $providers[$account->ulogin['network']])), 'status');
    }
    else {
      drupal_set_message(t('If you are completely sure it is your email address, try to login using your username and password on this site. If you don\'t remember your password - <a href="@password">request new password</a>.', array('@password' => url('user/password'))));
    }
  }
  else {
    global $ulogin_data;
    $ulogin_data = $data;
    user_external_login_register(_ulogin_make_username($data), 'ulogin');
    _ulogin_identity_save($data);
    
    $user_save_trigger = FALSE;
    $edit = array();
    //save user picture
    if (variable_get('user_pictures', 0) && variable_get('ulogin_pictures', 1)) {
      $photo_url = '';
      if (!empty($data['photo_big']) && $data['photo_big'] != 'http://ulogin.ru/img/photo_big.png') {
        $photo_url = $data['photo_big'];
      }
      elseif (!empty($data['photo']) && $data['photo'] != 'http://ulogin.ru/img/photo.png') {
        $photo_url = $data['photo'];
      }
      if ($photo_url) {
        $photo = drupal_http_request($photo_url);
        $file = file_save_data($photo->data, file_directory_temp() . '/' . md5($photo_url), FILE_EXISTS_REPLACE);
        
        $info = image_get_info($file);
        $destination = variable_get('user_picture_path', 'pictures') . '/picture-' . $user->uid . '.' . $info['extension'];
        if (file_copy($file, $destination, FILE_EXISTS_REPLACE)) {
          $edit['picture'] = $file;
          $user_save_trigger = TRUE;
        }
      }
    }
    //set email address
    if (!empty($data['email'])) {
      $edit['mail'] = $data['email'];
      $user_save_trigger = TRUE;
    }
    
    if ($user_save_trigger) {
      user_save($user, $edit);
    }
  }

  $destination = drupal_substr(drupal_get_destination(), 12);
  drupal_goto($destination);
}

function ulogin_user_identity($form_state, $account) {
  $identities = _ulogin_identity_load_by_uid($account->uid);
  $providers = _ulogin_providers_list();
  
  $header = array(t('Authentication provider'), t('Identity'), t('Delete'));
  $rows = array();
  $data_array = array();
  foreach ($identities as $identity) {
    $data = unserialize($identity['data']);
    $data_array[] = $data;
    $rows[] = array(
      $providers[$data['network']],
      l($data['identity'], $data['identity'], array('attributes' => array('target' => '_blank'), 'external' => TRUE)),
      l(t('Delete'), 'user/' . $account->uid . '/ulogin/delete/' . $identity['id']),
    );
  }
  
  $form = array();
  
  $form['identity'] = array(
    '#value' => theme('table', $header, $rows),
  );
  
  //add more identities
  if (user_access('use ulogin')) {
    $form['ulogin_widget'] = array(
      '#type' => 'ulogin_widget',
      '#title' => t('Add more identities'),
      '#ulogin_destination' => '',
    );
  }
  
  //tokens browser for admins
  if (user_access('administer site configuration') || user_access('administer users')) {
    $header = array(t('Token'), t('Value'));
    //user tokens
    if (!empty($account->ulogin)) {
      $form['fset_user_tokens'] = array(
        '#type' => 'fieldset',
        '#title' => t('User tokens'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
      );
      
      $rows = array();
      foreach ($account->ulogin as $key => $value) {
        if ($key != 'manual') {
          $rows[] = array('[user:ulogin:' . $key . ']', $value);
        }
      }
      $form['fset_user_tokens']['tokens'] = array(
        '#value' => theme('table', $header, $rows),
      );
    }
    
    //data from auth providers
    foreach ($data_array as $data) {
      $form['fset_' . $data['network'] . '_' . $data['uid']] = array(
        '#type' => 'fieldset',
        '#title' => $providers[$data['network']],
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
      );
      
      $rows = array();
      foreach ($data as $key => $value) {
        //if ($key != 'manual') {
          $rows[] = array($key, $value);
        //}
      }
      $form['fset_' . $data['network'] . '_' . $data['uid']]['tokens'] = array(
        '#value' => theme('table', $header, $rows),
      );
    }
  }
  
  return $form;
}

function ulogin_user_identity_delete($form_state, $account, $id) {
  $del_identity = _ulogin_identity_load_by_id($id);
  if (!$del_identity || $account->uid != $del_identity['uid']) {
    drupal_set_message(t('You are trying to delete non-existing identity.'), 'error');
    drupal_access_denied();
  }
  $del_identity_data = unserialize($del_identity['data']);
  //$username = theme('username', $account);
  $username = $account->name;
  $question = t('Are you sure you want to detach the uLogin identity !identity from %user?',
    array(
      '!identity' => l($del_identity_data['identity'], $del_identity_data['identity'], array('attributes' => array('target' => '_blank'), 'external' => TRUE)),
      '%user' => $username));
  
  $form = array();
  $form['#account'] = $account;
  $form['#del_identity'] = $del_identity;
  $form['#del_identity_data'] = $del_identity_data;
  $form['question'] = array(
    '#value' => $question,
    '#prefix' => '<div>',
    '#suffix' => '</div>',
  );
  
  if (!empty($account->ulogin) && $account->ulogin['network'] == $del_identity_data['network'] &&
    $account->ulogin['uid'] == $del_identity_data['uid']) {
    $identities = _ulogin_identity_load_by_uid($account->uid);
    $providers = _ulogin_providers_list();
    $options = array();
    foreach ($identities as $key => $identity) {
      $data = unserialize($identity['data']);
      if ($key != $id) {
        $options[$key] = $providers[$identity['network']] . ' - ' . l($data['identity'], $data['identity'], array('attributes' => array('target' => '_blank'), 'external' => TRUE));
      }
    }
    
    if (!empty($options)) {
      $form['explanation'] = array(
        '#value' => t('This identity was used to create your account. Please choose another identity to replace it.'),
        '#prefix' => '<div>',
        '#suffix' => '</div>',
      );
      $form['identity_choice'] = array(
        '#type' => 'radios',
        //'#title' => t('Identities'),
        '#options' => $options,
        '#default_value' => count($options) == 1 ? $key : NULL,
        //'#required' => TRUE, //required has bugs with radios http://drupal.org/node/811542
      );
    }
    else {
      $form['explanation'] = array(
        '#value' => t('This identity was used to create your account. To delete it you should first add another identity to your account.'),
        '#prefix' => '<div>',
        '#suffix' => '</div>',
      );
      return $form;
    }
  }
  
  $form = confirm_form($form, '', 'user/' . $account->uid . '/ulogin');
  drupal_set_title($username);
  
  return $form;
}

function ulogin_user_identity_delete_validate($form, &$form_state) {
  if (!empty($form['identity_choice']) && empty($form_state['values']['identity_choice'])) {
    form_set_error('identity_choice', t('Please choose identity for replacement.'));
  }
}

function ulogin_user_identity_delete_submit($form, &$form_state) {
  $account = $form['#account'];
  $del_identity = $form['#del_identity'];
  $del_identity_data = $form['#del_identity_data'];
  if (!empty($form_state['values']['identity_choice'])) {
    // Change ulogin data used for tokens.
    $identity = _ulogin_identity_load_by_id($form_state['values']['identity_choice']);
    $data = unserialize($identity['data']);
    $edit['ulogin'] = $data;
    // Change name.
    //$name = _ulogin_make_username($data);
    //$edit['name'] = $name;
    $account = user_save($account, $edit);
    
    // Change authname in authmap DB table.
    //user_set_authmaps($account, array('authname_ulogin' => $name));
  }
  
  $deleted = _ulogin_identity_delete_by_id($del_identity['id']);
  if ($deleted) {
    drupal_set_message(t('Identity deleted.'));
    // Invoke ulogin_identity_deleted rules event.
    if (module_exists('rules')) {
      rules_invoke_event('ulogin_identity_deleted', $account, $del_identity_data);
    }
  }
  
  $form_state['redirect'] = 'user/' . $form['#account']->uid . '/ulogin';
}
