<?php

/**
 * @file
 * Builds placeholder replacement tokens for ulogin-related data.
 */

/**
 * Implements hook_token_info().
 */
function ulogin_token_info() {
  $types = array();
  $types['ulogin'] = array(
    'name' => t('uLogin data'),
    'description' => t('Information about the user from the uLogin service.'),
    'needs-data' => 'user',
  );

  $tokens = array();
  $tokens['user']['ulogin'] = array(
    'name' => t('uLogin information'),
    'description' => t('Information from uLogin service.'),
    'type' => 'ulogin',
  );

  $tokens['ulogin']['network'] = array(
    'name' => t('Auth network'),
    'description' => t('Network providing authentication.'),
  );
  $tokens['ulogin']['identity'] = array(
    'name' => t('Identity'),
    'description' => t('Identity provided by uLogin.'),
  );
  $tokens['ulogin']['uid'] = array(
    'name' => t('UID'),
    'description' => t('UID provided by uLogin.'),
  );
  $tokens['ulogin']['email'] = array(
    'name' => t('Email'),
    'description' => t('Email address provided by uLogin.'),
  );
  $tokens['ulogin']['nickname'] = array(
    'name' => t('Nickname'),
    'description' => t('Nickname provided by uLogin.'),
  );
  $tokens['ulogin']['first_name'] = array(
    'name' => t('First name'),
    'description' => t('First name provided by uLogin.'),
  );
  $tokens['ulogin']['last_name'] = array(
    'name' => t('Last name'),
    'description' => t('Last name provided by uLogin.'),
  );
  $tokens['ulogin']['bdate'] = array(
    'name' => t('Birthday'),
    'description' => t('Birthday provided by uLogin.'),
  );
  $tokens['ulogin']['sex'] = array(
    'name' => t('Gender'),
    'description' => t('Gender provided by uLogin.'),
  );
  $tokens['ulogin']['photo'] = array(
    'name' => t('Photo'),
    'description' => t('Photo provided by uLogin.'),
  );
  $tokens['ulogin']['photo_big'] = array(
    'name' => t('Big photo'),
    'description' => t('Big photo provided by uLogin.'),
  );
  $tokens['ulogin']['country'] = array(
    'name' => t('Country'),
    'description' => t('Country provided by uLogin.'),
  );
  $tokens['ulogin']['city'] = array(
    'name' => t('City'),
    'description' => t('City provided by uLogin.'),
  );

  return array(
    'types' => $types,
    'tokens' => $tokens,
  );
}

/**
 * Implements hook_tokens().
 */
function ulogin_tokens($type, $tokens, array $data = array(), array $options = array()) {
  $sanitize = !empty($options['sanitize']);
  $replacements = array();

  if ($type == 'user' && !empty($data['user'])) {
    if (!empty($data['user']->data['ulogin'])) {
      $ulogin_tokens = token_find_with_prefix($tokens, 'ulogin');
      $replacements += token_generate('ulogin', $ulogin_tokens, array('ulogin' => $data['user']->data['ulogin']), $options);
    }
  }

  if ($type == 'ulogin' && !empty($data['ulogin'])) {
    foreach ($tokens as $name => $original) {
      $replacements[$original] = $sanitize ? check_plain($data['ulogin'][$name]) : $data['ulogin'][$name];
    }
  }

  return $replacements;
}
