<?php
/**
 * @file
 * Administration pages functions for uLogin module.
 */

function ulogin_settings_form() {
  $form = array();

  $form['vtabs'] = array(
    '#type' => 'vertical_tabs',
    '#attached' => array(
      'js' => array(drupal_get_path('module', 'ulogin') . '/js/ulogin.admin.js'),
    ),
  );

  $form['vtabs']['fset_display'] = array(
    '#type' => 'fieldset',
    '#title' => t('Widget settings'),
  );
  $form['vtabs']['fset_display']['ulogin_widget_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Widget title'),
    '#default_value' => variable_get('ulogin_widget_title', ''),
  );
  $form['vtabs']['fset_display']['ulogin_widget_id'] = array(
    '#type' => 'textfield',
    '#title' => t('Widget ID'),
    '#description' => t('Enter uLogin ID of the widget if you have configured one on the uLogin site.'),
    '#default_value' => variable_get('ulogin_widget_id', ''),
  );
  $form['vtabs']['fset_display']['ulogin_display'] = array(
    '#type' => 'radios',
    '#title' => t('Widget type'),
    '#description' => t('Select uLogin widget type.'),
    '#options' => array(
      'small' => t('Small icons'),
      'panel' => t('Big icons'),
      'window' => t('Popup window'),
      'buttons' => t('Custom icons'),
    ),
    '#default_value' => variable_get('ulogin_display', 'panel'),
  );
  $form['vtabs']['fset_display']['ulogin_icons_path'] = array(
    '#type' => 'textfield',
    '#title' => t('Custom icons path'),
    '#description' => t('Custom icons path relative to Drupal root directory. See !link for details.',
      array('!link' => l('custom buttons page', 'http://ulogin.ru/custom_buttons.html', array('attributes' => array('target' => '_blank'))))),
    '#default_value' => variable_get('ulogin_icons_path', ''),
    '#states' => array(
      'visible' => array(
        ':input[name="ulogin_display"]' => array('value' => 'buttons'),
      ),
    ),
  );
  $form['vtabs']['fset_display']['ulogin_widget_weight'] = array(
    '#type' => 'weight',
    '#title' => t('Widget weight'),
    '#description' => t('Determines the order of the elements on the form - heavier elements get positioned later.'),
    '#default_value' => variable_get('ulogin_widget_weight', -100),
    '#delta' => 100,
  );

  $form['vtabs']['fset_providers'] = array(
    '#type' => 'fieldset',
    '#title' => t('Authentication providers'),
  );

  $header = array(
    'name' => t('Name'),
  );
  $options = array();
  $weight = -50;
  $providers = _ulogin_providers_list();
  $enabled_providers = array_filter(variable_get('ulogin_providers_enabled', drupal_map_assoc(array('vkontakte', 'odnoklassniki', 'mailru', 'facebook', 'twitter', 'google', 'yandex', 'livejournal', 'openid'))));
  $main_providers = array_filter(variable_get('ulogin_providers_main', drupal_map_assoc(array('vkontakte', 'odnoklassniki', 'mailru', 'facebook'))));
  $main_providers = array_intersect_assoc($main_providers, $enabled_providers);
  $form['vtabs']['fset_providers']['ulogin_providers'] = array();
  foreach (array_keys($main_providers + $enabled_providers + $providers) as $provider_id) {
    $options[$provider_id] = array(
      'name' => $providers[$provider_id],
      '#attributes' => array('class' => array('draggable')),
    );
    $form['vtabs']['fset_providers']['ulogin_providers']['ulogin_provider_' . $provider_id . '_main'] = array(
      '#tree' => FALSE,
      '#type' => 'checkbox',
      '#default_value' => in_array($provider_id, $main_providers) && in_array($provider_id, $enabled_providers),
      '#states' => array(
        'disabled' => array(
          ':input[name="ulogin_providers[' . $provider_id . ']"]' => array('checked' => FALSE),
        ),
      ),
    );
    $form['vtabs']['fset_providers']['ulogin_providers']['ulogin_provider_' . $provider_id . '_weight'] = array(
      '#tree' => FALSE,
      '#type' => 'weight',
      '#delta' => 50,
      '#default_value' => $weight++,
      '#attributes' => array('class' => array('ulogin-providers-weight')),
    );
  }
  $form['vtabs']['fset_providers']['ulogin_providers'] += array(
    '#type' => 'tableselect',
    '#title' => t('Providers'),
    '#header' => $header,
    '#options' => $options,
    '#default_value' => $enabled_providers,
    '#pre_render' => array('ulogin_admin_providers_pre_render'),
  );

  $form['vtabs']['fset_fields'] = array(
    '#type' => 'fieldset',
    '#title' => t('Fields to request'),
  );

  $header = array(
    'name' => t('Name'),
  );
  $options = array();
  $fields = _ulogin_fields_list();
  $required_fields = array_filter(variable_get('ulogin_fields_required', drupal_map_assoc(array('first_name', 'last_name', 'email', 'nickname', 'bdate', 'sex', 'photo', 'photo_big', 'country', 'city'))));
  $optional_fields = array_filter(variable_get('ulogin_fields_optional', drupal_map_assoc(array('phone'))));
  $form['vtabs']['fset_fields']['ulogin_fields'] = array();
  foreach (array_keys($fields) as $field_id) {
    $options[$field_id] = array(
      'name' => $fields[$field_id],
      '#attributes' => array('class' => array('draggable')),
    );
    $form['vtabs']['fset_fields']['ulogin_fields']['ulogin_field_' . $field_id . '_required'] = array(
      '#tree' => FALSE,
      '#type' => 'checkbox',
      '#default_value' => in_array($field_id, $required_fields),
      '#states' => array(
        'disabled' => array(
          ':input[name="ulogin_fields[' . $field_id . ']"]' => array('checked' => FALSE),
        ),
      ),
    );
  }
  $form['vtabs']['fset_fields']['ulogin_fields'] += array(
    '#type' => 'tableselect',
    '#title' => t('Fields'),
    '#header' => $header,
    '#options' => $options,
    '#default_value' => $required_fields + $optional_fields,
    '#pre_render' => array('ulogin_admin_fields_pre_render'),
  );

  $form['vtabs']['fset_account'] = array(
    '#type' => 'fieldset',
    '#title' => t('Account settings'),
  );
  $form['vtabs']['fset_account']['ulogin_disable_username_change'] = array(
    '#type' => 'checkbox',
    '#title' => t('Disable username change'),
    '#description' => t('Remove username field from user account edit form for users created by uLogin.'
      . ' If this is unchecked then users should also have "Change own username" permission to actually be able to change the username.'),
    '#default_value' => variable_get('ulogin_disable_username_change', 1),
  );
  $form['vtabs']['fset_account']['ulogin_remove_password_fields'] = array(
    '#type' => 'checkbox',
    '#title' => t('Remove password fields'),
    '#description' => t('Remove password fields from user account edit form for users created by uLogin.'),
    '#default_value' => variable_get('ulogin_remove_password_fields', 1),
  );
  $form['vtabs']['fset_account']['ulogin_pictures'] = array(
    '#type' => 'checkbox',
    '#title' => t('Save uLogin provided picture as user picture'),
    '#description' => t('Save pictures provided by uLogin as user pictures. Check the "Enable user pictures" option at <a href="!link">Account settings</a> to make this option available.',
      array('!link' => url('admin/config/people/accounts'))),
    '#default_value' => variable_get('ulogin_pictures', 1),
    '#disabled' => !variable_get('user_pictures', 0),
  );
  $form['vtabs']['fset_account']['ulogin_email_confirm'] = array(
    '#type' => 'checkbox',
    '#title' => t('Confirm emails'),
    '#description' => t('Confirm manually entered emails - if you require email address and authentication provider does not provide one. Install !link module to make this option available.',
      array('!link' => l(t('Email Change Confirmation'), 'http://drupal.org/project/email_confirm', array('attributes' => array('target' => '_blank'))))),
    '#default_value' => variable_get('ulogin_email_confirm', 0),
    '#disabled' => !module_exists('email_confirm'),
  );
  $form['vtabs']['fset_account']['ulogin_username'] = array(
    '#type' => 'textfield',
    '#title' => t('Username pattern'),
    '#description' => t('Create username for new users using this pattern; counter will be added in case of username conflict.') . ' ' .
      t('Install !link module to get list of all available tokens.',
        array('!link' => l(t('Token'), 'http://drupal.org/project/token', array('attributes' => array('target' => '_blank'))))) . ' ' .
      t('You should use only uLogin tokens here as the user is not created yet.'),
    '#default_value' => variable_get('ulogin_username', 'ulogin_[user:ulogin:network]_[user:ulogin:uid]'),
    '#required' => TRUE,
  );
  $form['vtabs']['fset_account']['ulogin_display_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Display name pattern'),
    '#description' => t('Leave empty to not alter display name. You can use any user tokens here.') . ' '
      . t('Install !link module to get list of all available tokens.',
        array('!link' => l(t('Token'), 'http://drupal.org/project/token', array('attributes' => array('target' => '_blank'))))),
    '#default_value' => variable_get('ulogin_display_name', '[user:ulogin:first_name] [user:ulogin:last_name]'),
  );
  if (module_exists('token')) {
    $form['vtabs']['fset_account']['fset_token'] = array(
      '#type' => 'fieldset',
      '#title' => t('Tokens'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['vtabs']['fset_account']['fset_token']['ulogin_token_tree'] = array(
      '#theme' => 'token_tree',
      '#token_types' => array('user'),
      '#global_types' => FALSE,
      '#dialog' => TRUE,
    );
  }
  $form['vtabs']['fset_account']['ulogin_override_realname'] = array(
    '#type' => 'checkbox',
    '#title' => t('Override Real name'),
    '#description' => t('Override <a href="!link1">Real name settings</a> using the above display name pattern for users created by uLogin. This option is available only if !link2 module is installed.',
      array('!link1' => url('admin/config/people/realname'),
        '!link2' => l(t('Real name'), 'http://drupal.org/project/realname', array('attributes' => array('target' => '_blank'))))),
    '#default_value' => variable_get('ulogin_override_realname', 0),
    '#disabled' => !module_exists('realname'),
  );

  $form['vtabs']['fset_other'] = array(
    '#type' => 'fieldset',
    '#title' => t('Other settings'),
  );
  /*$form['vtabs']['fset_other']['ulogin_redirect'] = array(
    '#type' => 'checkbox',
    '#title' => t('Do not reload/redirect'),
    '#default_value' => variable_get('ulogin_redirect', 0),
  );*/
  $form['vtabs']['fset_other']['ulogin_destination'] = array(
    '#type' => 'textfield',
    '#title' => t('Redirect after login'),
    '#default_value' => variable_get('ulogin_destination', ''),
    '#description' => t('Drupal path to redirect to, like "node/1". Leave empty to return to the same page (set to [HTTP_REFERER] for widget in modal dialogs loaded by AJAX).'),
  );
  $form['vtabs']['fset_other']['ulogin_forms'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Drupal forms'),
    '#description' => t('Add default uLogin widget to these forms.'),
    '#options' => array(
      'user_login' => t('User login form'),
      'user_login_block' => t('User login block'),
      'user_register_form' => t('User registration form'),
      'comment_form' => t('Comment form'),
    ),
    '#default_value' => variable_get('ulogin_forms', array('user_login', 'user_login_block')),
  );
  $form['vtabs']['fset_other']['ulogin_duplicate_emails'] = array(
    '#type' => 'radios',
    '#title' => t('Duplicate emails'),
    '#description' => t('Select how to handle duplicate email addresses. This situation occurs when the same user is trying to authenticate using different authentication providers, but with the same email address.'),
    '#options' => array(
      0 => t('Allow duplicate email addresses'),
      1 => t("Don't allow duplicate email addresses, block registration and advise to log in using the existing account"),
    ),
    '#default_value' => variable_get('ulogin_duplicate_emails', 1),
  );

  return system_settings_form($form);
}

/**
 * Pre-render callback for the providers tableselect.
 */
function ulogin_admin_providers_pre_render($element) {
  // Add "main" column.
  $element['#header']['main'] = t('Main');
  foreach (array_keys($element['#options']) as $provider_id) {
    $key = 'ulogin_provider_' . $provider_id . '_main';
    $element['#options'][$provider_id]['main'] = array(
      'data' => drupal_render($element[$key]),
    );
    unset($element[$key]);
  }
  // Add "weight" column.
  $element['#header']['weight'] = t('Weight');
  foreach (array_keys($element['#options']) as $provider_id) {
    $key = 'ulogin_provider_' . $provider_id . '_weight';
    $element['#options'][$provider_id]['weight'] = array(
      'data' => drupal_render($element[$key]),
    );
    unset($element[$key]);
  }

  // Assign id to the table.
  $table_id = 'ulogin-providers';
  $element['#attributes'] = array('id' => $table_id);
  drupal_add_tabledrag($table_id, 'order', 'sibling', 'ulogin-providers-weight');
  return $element;
}

/**
 * Pre-render callback for the fields tableselect.
 */
function ulogin_admin_fields_pre_render($element) {
  // Add "required" column.
  $element['#header']['required'] = t('Required');
  foreach (array_keys($element['#options']) as $field_id) {
    $key = 'ulogin_field_' . $field_id . '_required';
    $element['#options'][$field_id]['required'] = array(
      'data' => drupal_render($element[$key]),
    );
    unset($element[$key]);
  }

  return $element;
}

/**
 * Form validation handler for the ulogin admin settings form.
 */
function ulogin_settings_form_validate($form, &$form_state) {
  $values = &$form_state['values'];
  $providers = _ulogin_providers_list();
  $fields = _ulogin_fields_list();

  // Process 'main' checkboxes and remove them.
  $providers_main_values = array();
  foreach (array_keys($providers) as $provider_id) {
    $providers_main_values[$provider_id] = $values['ulogin_provider_' . $provider_id . '_main'] ? $provider_id : '';
    unset($values['ulogin_provider_' . $provider_id . '_main']);
  }
  // Remove weights so they are not saved as variables.
  $providers_weights = array();
  foreach (array_keys($providers) as $provider_id) {
    $providers_weights[$provider_id] = $values['ulogin_provider_' . $provider_id . '_weight'];
    unset($values['ulogin_provider_' . $provider_id . '_weight']);
  }
  asort($providers_weights);

  $providers_enabled_values = $values['ulogin_providers'];
  unset($values['ulogin_providers']);

  $values['ulogin_providers_enabled'] = array();
  $values['ulogin_providers_main'] = array();
  foreach (array_keys($providers_weights) as $provider_id) {
    $values['ulogin_providers_enabled'][$provider_id] = $providers_enabled_values[$provider_id];
    $values['ulogin_providers_main'][$provider_id] = $providers_main_values[$provider_id];
  }

  // Process 'required' checkboxes and remove them.
  $fields_required_values = array();
  foreach (array_keys($fields) as $field_id) {
    $fields_required_values[$field_id] = $values['ulogin_field_' . $field_id . '_required'] ? $field_id : '';
    unset($values['ulogin_field_' . $field_id . '_required']);
  }

  $fields_enabled_values = $values['ulogin_fields'];
  unset($values['ulogin_fields']);

  $values['ulogin_fields_required'] = $fields_required_values;
  $values['ulogin_fields_optional'] = array_diff_assoc($fields_enabled_values, $fields_required_values);
}

function ulogin_report() {
  $providers = _ulogin_providers_list();

  $header = array(t('Authentication provider'), t('Users count'));
  $rows = array();
  $query = db_select('ulogin_identity', 'ul_id');
  $query->addField('ul_id', 'network', 'network');
  $query->addExpression('COUNT(ulogin_uid)', 'count');
  $query->groupBy('network');
  $results = $query
    ->execute()
    ->fetchAllAssoc('network', PDO::FETCH_ASSOC);
  foreach ($results as $result) {
    $rows[] = array(
      $providers[$result['network']],
      $result['count'],
    );
  }

  $form = array();

  $form['report'] = array(
    '#theme' => 'table',
    '#header' => $header,
    '#rows' => $rows,
  );

  return $form;
}
