(function ($, Drupal) {
  Drupal.behaviors.ultimateTableField = {
    attach(context, settings) {
      const tableContainer = document.querySelector(
        '.field--type-ultimate-table',
      );
      const stickyButton = tableContainer.querySelector(
        '.table-actions-container',
      );

      if (!stickyButton || !tableContainer) {
        return;
      }

      function syncScrollbars(container) {
        const topScroll = container.querySelector('.top-scroll');
        const contentWrapper = container.querySelector('.table-responsive');
        const table = contentWrapper?.querySelector('table');

        if (topScroll && contentWrapper && table) {
          topScroll.querySelector('.top-scroll-content').style.width =
            `${table.offsetWidth}px`;
          topScroll.addEventListener('scroll', () => {
            contentWrapper.scrollLeft = topScroll.scrollLeft;
          });
          contentWrapper.addEventListener('scroll', () => {
            topScroll.scrollLeft = contentWrapper.scrollLeft;
          });
        }
      }

      // Initial setup and AJAX handling
      syncScrollbars(tableContainer);

      // Handle sticky header
      document.addEventListener('scroll', () => {
        const adminToolbar = document.querySelector('#toolbar-administration');
        const toolbarHeight = adminToolbar?.offsetHeight || 0;
        const tableOffset = tableContainer.offsetTop;
        const tableBottom = tableOffset + tableContainer.offsetHeight;
        const scrollPosition =
          window.pageYOffset || document.documentElement.scrollTop || 0;
        const threshold = toolbarHeight + 60;
        const bottomBuffer = 50; // Buffer zone to prevent glitchy effect

        if (
          scrollPosition >= tableOffset - threshold &&
          scrollPosition < tableBottom - (threshold + bottomBuffer)
        ) {
          tableContainer.classList.add('js-fixed-table');
          tableContainer.classList.remove('js-table-bottom');
        } else if (scrollPosition >= tableBottom - (threshold + bottomBuffer)) {
          tableContainer.classList.remove('js-fixed-table');
          tableContainer.classList.add('js-table-bottom');
        } else {
          tableContainer.classList.remove('js-fixed-table', 'js-table-bottom');
        }
      });
    },
  };
})(jQuery, Drupal);
