<?php

namespace Drupal\ultimate_table_field;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Ultimate table cell field plugin base.
 */
abstract class UltimateTableCellFieldBase extends PluginBase implements UltimateTableCellFieldInterface {

  use StringTranslationTrait;

  /**
   * {@inheritDoc}
   */
  public function id(): string {
    return $this->pluginDefinition['id'] ?? '';
  }

  /**
   * {@inheritDoc}
   */
  public function label(): string {
    return $this->pluginDefinition['label'] ?? '';
  }

  /**
   * {@inheritDoc}
   */
  public function generateSummary($data = NULL): array {
    return [
      '#type' => 'markup',
      '#markup' => '<p><strong>Type:</strong> ' . ($this->label() ?? $this->id()) . '</p>',
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function cellFieldAlterSubmitted(mixed &$submitted_value) {}

  /**
   * {@inheritDoc}
   */
  public function cellFieldValidate() {}

  /**
   * {@inheritDoc}
   */
  public function cellFieldFormatter(array $item): array {
    $type = $item['type'] ?? '';
    return [
      '#type' => 'markup',
      '#markup' => "<strong>$type</strong>",
    ];

  }

}
