<?php

namespace Drupal\ultimate_table_field\Plugin\UltimateTable\CellField;

use Drupal\ultimate_table_field\UltimateTableCellFieldBase;

/**
 * Provides text field cell form element.
 *
 * @UltimateTableCellField(
 *   id="text_long",
 *   label=@Translation("Default text long"),
 * )
 */
class TextLong extends UltimateTableCellFieldBase {

  /**
   * {@inheritDoc}
   */
  public function buildCellField($default_value = NULL): array {
    return [
      '#type' => 'textarea',
      '#title' => $this->t('Text'),
      '#default_value' => $default_value,
      '#required' => TRUE,
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function cellFieldFormatter(array $item): array {
    return [
      '#type' => 'container',
      'text' => [
        '#markup' => $item['text_long'],
      ],
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function generateSummary($data = NULL): array {
    return [
      '#type' => 'markup',
      '#markup' => $this->t('<p><strong>Type:</strong> @label <strong>Text:</strong> @text </p>', [
        '@label' => $this->label(),
        '@text' => substr($data[$this->id()], 0, 20) . '...',
      ]),
    ];
  }

}
