<?php

namespace Drupal\ultimate_table_field;

/**
 * Ultimate table cell plugin interface.
 */
interface UltimateTableCellFieldInterface {

  /**
   * Get plugin ID.
   */
  public function id(): string;

  /**
   * Get plugin label.
   */
  public function label(): string;

  /**
   * Build cell field form.
   */
  public function buildCellField($default_value = NULL): array;

  /**
   * Generate field value summary.
   */
  public function generateSummary($data = NULL): array;

  /**
   * Alter cell field submitted value.
   */
  public function cellFieldAlterSubmitted(mixed &$submitted_value);

  /**
   * Alter cell field formatter.
   */
  public function cellFieldFormatter(array $item): array;

  /**
   * Cell field form validation.
   */
  public function cellFieldValidate();

}
