<?php

namespace Drupal\ultimate_table_field;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * A plugin manager for ultimate table field.
 */
class UltimateTableCellFieldManager extends DefaultPluginManager {

  /**
   * Creates the discovery object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    $subdir = 'Plugin/UltimateTable/CellField';
    $plugin_interface = 'Drupal\ultimate_table_field\UltimateTableCellFieldInterface';

    // The name of the annotation class that contains the plugin definition.
    $plugin_definition_annotation_name = 'Drupal\ultimate_table_field\Annotation\UltimateTableCellField';

    parent::__construct($subdir, $namespaces, $module_handler, $plugin_interface, $plugin_definition_annotation_name);

    // This allows the plugin definitions to be altered by an alter hook.
    $this->alterInfo('ultimate_table_cell_field_info');

    // This sets the caching method for our plugin definitions.
    $this->setCacheBackend($cache_backend, 'ultimate_table_cell_field_info');
  }

}
