<?php

namespace Drupal\ultimate_table_field\Controller;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\OpenDialogCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\FormBuilderInterface;
use Drupal\ultimate_table_field\Form\ModalForm;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Modal form controller.
 */
class ModalFormController extends ControllerBase {

  /**
   * Form builder service.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * Ultimate table modal form constructor.
   *
   * @param \Drupal\Core\Form\FormBuilderInterface $formBuilder
   *   Form builder service.
   */
  public function __construct(FormBuilderInterface $formBuilder) {
    $this->formBuilder = $formBuilder;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('form_builder')
    );
  }

  /**
   * Callback for opening the modal form.
   */
  public function openModalForm() {
    $response = new AjaxResponse();

    // Get the modal form using the form builder.
    $modal_form = $this->formBuilder->getForm('Drupal\ultimate_table_field\Form\ModalForm');

    // Add an AJAX command to open a modal dialog with the form as the content.
    $response->addCommand(new OpenDialogCommand(ModalForm::MODAL_FORM_WRAPPER_CSS_ID, $this->t('Data'), $modal_form, [
      'width' => '50%',
      'modal' => TRUE,
    ]));

    return $response;
  }

}
