<?php

/**
 * @file
 * Hooks for unep_maps module.
 */

/**
 * Alters country data displayed on the map.
 *
 * This hook can add a new country or overwrite country data used in Mapbox.
 *
 * Available keys:
 * - ios3: ISO3 country code (string)
 * - popup: Popup content (HTML string)
 * - link: Link opened when the country is clicked (URL string)
 * - countryColor: Country background color (HEX color code, optional)
 * - countryHover: Country hover color (HEX color code, optional)
 *
 * @param array $countryData
 *   The data to alter.
 */
function hook_unep_maps_country_data_alter(array &$countryData) {
  $countryData[] = [
    'iso3' => 'TWN',
    'popup' => 'Taiwan, Province of China',
    'link' => '/countries/chn',
    'color' => '#8FA1FA',
    'hoverColor' => '#637CF8',
  ];

  $countryData[] = [
    'iso3' => 'FLK',
    'popup' => 'Falkland Islands (Malvinas)',
    'link' => '/countries/gbr',
    'color' => '#8FA1FA',
    'hoverColor' => '#637CF8',
  ];
}

/**
 * Alters pin data displayed on the map.
 *
 * This hook can add a new pin or overwrite pin data used in Mapbox.
 *
 * Available keys:
 * - coordinates: Coordinates (array [lon, lat])
 * - popup: Popup content (html string)
 *
 * @param array $pinData
 *   The data to alter.
 */
function hook_unep_maps_pin_data_alter(array &$pinData) {
  $pinData[] = [
    'coordinates' => [-74.0060, 40.7128],
    'popup' => 'New York, United States',
  ];
}

/**
 * Alters area data displayed on the map.
 *
 * This hook can add a new area polygon or overwrite polygons data used in
 * Mapbox using geometry features.
 *
 * @param array $areaData
 *   The data to alter.
 */
function hook_unep_maps_area_data_alter(array &$areaData) {
  $wktPolygon = 'POLYGON ((9.0 46.5, 12.5 45.8, 14.0 43.5, 15.5 41.0, 14.0 38.5, 11.5 40.0, 10.0 43.0, 9.0 46.5))';

  $geometry = \geoPHP::load($wktPolygon, 'wkt');
  $geoJsonGeometry = json_decode($geometry->out('json'), TRUE);

  $geoJsonFeature = [
    'type' => 'Feature',
    'geometry' => $geoJsonGeometry,
    'properties' => [
      'id' => 'new-polygon',
      'popup' => 'New zone',
      'color' => '#8FA1FA',
      'hoverColor' => "#637CF8",
    ],
  ];

  $areaData['features'][] = $geoJsonFeature;
}
