/* eslint-env node */
const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const postcss = require('gulp-postcss');
const autoprefixer = require('autoprefixer');
const cleanCSS = require('gulp-clean-css');
const rename = require('gulp-rename');
const plumber = require('gulp-plumber');
const del = require('delete');
const insert = require('gulp-insert');

const paths = {
  scss: 'scss/**/*.scss',
  scssPartials: '!scss/**/_*.scss',
  css: 'css', // delete this folder before each compile
  destBase: '.',
};

// Clean CSS folder
async function cleanCss() {
  return new Promise((resolve, reject) => {
    del([paths.css], (err) => {
      if (err) {
        reject(err);
      }
      resolve();
    });
  });
}

// Compile SCSS
function compileScss() {
  return gulp
    .src([paths.scss, paths.scssPartials], { base: '.' })
    .pipe(plumber())
    .pipe(sass({ outputStyle: 'expanded' }).on('error', sass.logError))
    .pipe(postcss([autoprefixer()]))
    .pipe(
      rename((filePath) => {
        filePath.dirname = filePath.dirname.replace(/^scss/, 'css');
      }),
    )
    .pipe(insert.append('\n'))
    .pipe(gulp.dest(paths.destBase))
    .pipe(cleanCSS({ level: 2 }))
    .pipe(
      rename({
        suffix: '.min',
        extname: '.css',
      }),
    )
    .pipe(gulp.dest(paths.destBase));
}

// Watch SCSS
function watchScss() {
  gulp.watch(paths.scss, gulp.series(cleanCss, compileScss));
}

exports.cleanCss = cleanCss;
exports.build = gulp.series(cleanCss, compileScss);
exports.watch = gulp.series(cleanCss, compileScss, watchScss);
exports.default = gulp.series(cleanCss, compileScss);
