<?php

namespace Drupal\unified_date\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for entities.
 */
class UnifiedDateHook {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    if ($route_name === 'help.page.unified_date') {
      $output = '<h3>' . $this->t('About') . '</h3>';
      $output .= '<p>' . $this->t('A module to store a date field value in a unified date field on the base node table for multiple content type listing sorting.') . '</p>';
      return $output;
    }
    return NULL;
  }

}
