<?php

namespace Drupal\unified_date\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for views.
 */
class ViewsHook {

  /**
   * Implements hook_views_data_alter().
   */
  #[Hook('views_data_alter')]
  public function viewsDataAlter(array &$data): void {
    if (isset($data['node_field_data']['unified_date'])) {
      // Use the Unified Datetime Views Filter Plugin for the unified date
      // field.
      $data['node_field_data']['unified_date']['filter']['id'] = 'unified_datetime';
    }
  }

}
