<?php
/**
 * Created by PhpStorm.
 * User: steve
 * Date: 20/07/18
 * Time: 14:23
 */

namespace Drupal\universal_file_utils\Event;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Session\AccountInterface;

class UniversalFileAccessEvent extends UniversalFileBaseEvent {

  const string NAME = 'universal_file_utils.access';

  /**
   * Set up access results.
   *
   * @return array
   */
  public function getExtras(): array {
    return [
      'accessResults' => [],
    ] + parent::getExtras();
  }

  /**
   * @param string $source
   */
  public function allowed(string $source): void {
    $this->setAccessResult($source, AccessResult::allowed());
  }

  /**
   * @param string $source
   */
  public function neutral(string $source): void {
    $this->setAccessResult($source, AccessResult::neutral());
  }

  /**
   * @param string $source
   */
  public function forbidden(string $source): void {
    $this->setAccessResult($source, AccessResult::forbidden());
  }

  /**
   * @param string $source
   *
   * @param AccessResultInterface $accessResult
   */
  public function setAccessResult(string $source, AccessResultInterface $accessResult): void {
    $this->extras['accessResults'][$source] = $accessResult;
  }

  /**
   * Process any results we got from this event to see whether we are
   * allowing, forbidding, or we just don't care.
   *
   * @return AccessResultInterface
   */
  public function getAccessResult(): AccessResultInterface {
    // Default the result to neutral...
    $result = AccessResult::neutral();

    /** @var AccessResultInterface $accessResult */
    foreach ($this->get('accessResults', []) as $accessResult) {
      // We just ignore neutrals...
      if (!$accessResult->isNeutral()) {
        if ($accessResult->isForbidden()) {
          // Just one forbidden makes this forbidden. Exit loop.
          $result = $accessResult;
          break;
        }
      }
    }
    return $result;
  }

  /**
   * @return string
   */
  public function getOperation(): string {
    return $this->get('operation');
  }

  /**
   * @return AccountInterface
   */
  public function getAccount(): AccountInterface {
    return $this->get('account');
  }

}
