<?php
/**
 * Created by PhpStorm.
 * User: steve
 * Date: 20/07/18
 * Time: 14:23
 */

namespace Drupal\universal_file_utils\Event;

class UniversalFileDownloadEvent extends UniversalFileBaseEvent {

  const string NAME = 'universal_file_utils.download';

  /**
   * Must be private in this case, don't want derived classes messing with it.
   */
  private array|int $headers = [];

  private bool $denyDownload = FALSE;

  /**
   * @return string[] | int
   */
  public function getHeaders(): array|int {
    return $this->downloadDenied() ? -1 : $this->headers;
  }

  /**
   * Add these headers.
   *
   * @param string[] $headers
   */
  public function setHeaders(array $headers): void {
    $this->headers = array_merge($this->headers, $headers);
  }

  /**
   * Prevent download of this file.
   */
  public function denyDownload(): void {
    $this->denyDownload = TRUE;
  }

    /**
     * @return bool
     */
  public function downloadDenied(): bool {
    return $this->denyDownload;
  }

}
