<?php

namespace Drupal\universal_file_utils\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class UFUHooks {

  /**
   * Implements hook_module_implements_alter().
   */
  #[Hook('module_implements_alter')]
  function universal_file_utils_module_implements_alter(&$implementations, $hook): void {
    // Move our hook_file_download() implementation to the start of the list.
    if ($hook == 'file_download') {
      $group = $implementations['universal_file_utils'];
      unset($implementations['universal_file_utils']);
      $implementations = ['universal_file_utils' => $group] + $implementations;
    }
  }

  /**
   * Implements hook_file_download().
   */
  #[Hook('file_download')]
  function universal_file_utils_file_download($uri): array|int|null {
    if (!str_contains($uri, '/system/files/')) {
      if (!str_contains($uri, 'private://')) {
        return [];
      }
    }
    return \Drupal::service('universal_file_utils.operations')->HookFileDownload($uri);
  }

  /**
   * Implements hook_file_access().
   */
  #[Hook('file_access')]
  function universal_file_utils_file_access($entity, $operation, $account) {
    return \Drupal::service('universal_file_utils.operations')->HookFileAccess($entity, $operation, $account);
  }

}