# UPSC Quiz Module

An interactive quiz application for UPSC (Union Public Service Commission) exam preparation with multiple subjects, timer functionality, and detailed analytics.

## Features

- **Multiple Quiz Sections**: Polity, History, Geography, Economics, General Science, Current Affairs
- **Interactive Interface**: Modern, responsive design with smooth animations
- **Timer Functionality**: Configurable time limits with visual warnings
- **Progress Tracking**: Real-time progress indicators and analytics
- **Answer Review**: Detailed review with explanations after quiz completion
- **User Management**: Support for both authenticated and anonymous users
- **Retake Options**: Allow users to retake quizzes with configurable settings
- **Admin Configuration**: Comprehensive settings panel for quiz customization
- **Database Integration**: Full CRUD operations with MySQL/PostgreSQL support
- **Mobile Responsive**: Optimized for desktop, tablet, and mobile devices

## Requirements

- Drupal 9.x, 10.x, or 11.x
- PHP 7.4 or higher
- MySQL 5.7+ or PostgreSQL 10+
- Modern web browser with JavaScript enabled

## Installation

### Method 1: Manual Installation

1. Download the module files
2. Extract to your Drupal installation's `modules/custom/` directory
3. Enable the module via Drupal admin interface or drush:
   ```bash
   drush en upsc_quiz
   ```

### Method 2: Composer Installation (if available)

```bash
composer require drupal/upsc_quiz
drush en upsc_quiz
```

### Method 3: Drush Installation

```bash
drush dl upsc_quiz
drush en upsc_quiz
```

## Configuration

### Basic Setup

1. Navigate to **Configuration > Education > UPSC Quiz Settings** (`/admin/config/content/upsc-quiz`)
2. Configure the following settings:

#### General Settings
- **Time Limit**: Set quiz duration in minutes (0 = no limit)
- **Enable Analytics**: Track question performance and user statistics
- **Allow Retake**: Allow users to retake completed quizzes
- **Show Correct Answers**: Display correct answers in review mode

#### Question Settings
- **Randomize Questions**: Shuffle question order for each attempt
- **Randomize Options**: Shuffle answer options (A, B, C, D)
- **Questions per Section**: Number of questions to display per quiz section

#### Email Notifications
- **Notify Admin**: Send email notifications for quiz completions
- **Admin Email**: Email address for administrative notifications

#### Advanced Settings
- **Cache Questions**: Enable question caching for better performance
- **Debug Mode**: Enable detailed logging for troubleshooting

### Question Management

The module comes with sample questions, but you can add more through the database or by extending the install hooks.

#### Adding Questions via Database

Questions are stored in the `upsc_quiz_questions` table with the following structure:

```sql
INSERT INTO upsc_quiz_questions (section, question, option_a, option_b, option_c, option_d, correct_answer, explanation, difficulty, status, created, changed) 
VALUES ('Polity', 'Your question text?', 'Option A', 'Option B', 'Option C', 'Option D', 'B', 'Explanation text', 2, 1, UNIX_TIMESTAMP(), UNIX_TIMESTAMP());
```

## Usage

### For End Users

1. **Access the Quiz**: Navigate to `/upsc-quiz` on your Drupal site
2. **Select Section**: Choose from available quiz sections (Polity, History, etc.)
3. **Start Quiz**: Click "Start Quiz" to begin
4. **Answer Questions**: Select answers and navigate using Previous/Next buttons
5. **Review Results**: View score, time taken, and accuracy after completion
6. **Review Answers**: (if enabled) See correct answers with explanations

### For Administrators

1. **Monitor Usage**: View analytics at `/admin/config/content/upsc-quiz/analytics`
2. **Manage Settings**: Configure quiz behavior through the admin interface
3. **Export Data**: Download user performance data for analysis
4. **Question Management**: Add, edit, or remove questions as needed

## Database Schema

### Tables Created

- **upsc_quiz_questions**: Stores quiz questions with options and answers
- **upsc_quiz_attempts**: Records user quiz attempts and results
- **upsc_quiz_responses**: Individual question responses for each attempt
- **upsc_quiz_analytics**: Performance analytics for questions and sections

### Key Fields

#### Questions Table
- `section`: Quiz section (Polity, History, etc.)
- `question`: Question text
- `option_a/b/c/d`: Multiple choice options
- `correct_answer`: Correct option (A, B, C, or D)
- `explanation`: Optional explanation text
- `difficulty`: Difficulty level (1-5)

#### Attempts Table
- `uid`: User ID (0 for anonymous)
- `session_id`: Session identifier for anonymous users
- `score`: Final score achieved
- `time_taken`: Time spent in seconds
- `completed`: Completion status

## Customization

### Theming

The module uses Twig templates located in `templates/`:

- `upsc-quiz-main.html.twig`: Main quiz interface template

Override these templates in your theme to customize the appearance.

### CSS Customization

The default styles are in `css/upsc-quiz.css`. You can:

1. Override specific CSS rules in your theme
2. Replace the entire stylesheet by defining a custom library
3. Use the CSS custom properties for easy color/spacing adjustments

### JavaScript Customization

The quiz logic is in `js/upsc-quiz.js` and uses Drupal's JavaScript API. You can:

1. Extend the `UPSCQuizApp` class
2. Add custom behaviors using `Drupal.behaviors`
3. Hook into quiz events for custom functionality

## API Endpoints

The module provides REST API endpoints:

- `GET /upsc-quiz/api/questions/{section}`: Fetch questions for a section
- `POST /upsc-quiz/api/submit`: Submit quiz answers
- `GET /upsc-quiz/api/results/{attempt_id}`: Get results for an attempt
- `GET /upsc-quiz/api/analytics/{section}`: Get analytics data

## Permissions

The module defines these permissions:

- **Access UPSC Quiz**: Basic permission to take quizzes
- **Administer UPSC Quiz**: Full administrative access
- **View UPSC Quiz Analytics**: Access to analytics and reports

Assign these permissions to appropriate user roles via **People > Permissions**.

## Troubleshooting

### Common Issues

#### Quiz Not Loading
- Check that JavaScript is enabled
- Verify the module is properly enabled
- Check browser console for JavaScript errors

#### Questions Not Appearing
- Ensure sample questions were installed correctly
- Check database permissions
- Verify the questions table has data

#### Timer Not Working
- Confirm JavaScript is enabled
- Check that time limit is set in configuration
- Verify browser supports modern JavaScript features

#### Styling Issues
- Clear Drupal cache: `drush cr`
- Check that CSS files are loading
- Verify theme compatibility

### Debug Mode

Enable debug mode in the configuration to get detailed logging:

1. Go to Configuration > UPSC Quiz Settings
2. Check "Debug Mode" under Advanced Settings
3. Save configuration
4. Check Drupal logs at Reports > Recent log messages

### Performance Optimization

For better performance:

1. Enable question caching in settings
2. Use a Redis or Memcache backend for caching
3. Optimize database indices for large question sets
4. Enable CSS/JS aggregation in Drupal

## Development

### File Structure

```
upsc_quiz/
├── upsc_quiz.info.yml           # Module definition
├── upsc_quiz.module             # Hook implementations
├── upsc_quiz.routing.yml        # Route definitions
├── upsc_quiz.libraries.yml      # Asset libraries
├── upsc_quiz.install            # Install/uninstall hooks
├── src/
│   ├── Controller/
│   │   ├── QuizController.php   # Main quiz controller
│   │   └── ApiController.php    # API endpoints
│   └── Form/
│       └── AdminSettingsForm.php # Configuration form
├── templates/
│   └── upsc-quiz-main.html.twig # Main template
├── css/
│   └── upsc-quiz.css           # Stylesheets
└── js/
    └── upsc-quiz.js            # JavaScript application
```

### Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests if applicable
5. Submit a pull request

### Testing

Run tests using PHPUnit:

```bash
vendor/bin/phpunit modules/custom/upsc_quiz/tests/
```

## Security Considerations

- All user inputs are sanitized using Drupal's security APIs
- CSRF protection is implemented for form submissions
- SQL injection prevention through Drupal's database abstraction layer
- XSS protection via Twig's automatic escaping

## License

This module is licensed under the GNU General Public License v2.0 or later.

## Support

For support, please:

1. Check the troubleshooting section above
2. Search existing issues on the project page
3. Create a new issue with detailed information about your problem

## Changelog

### Version 1.0.0
- Initial release
- Basic quiz functionality with 6 sections
- Timer and progress tracking
- Administrative configuration interface
- Responsive design with modern UI
- Database schema with analytics support
- Sample questions for all sections
- Full Drupal 9/10/11 compatibility