<?php

namespace Drupal\urct\Event;

use Drupal\urct\ReferralItem;
use Symfony\Contracts\EventDispatcher\Event;

class ReferralItemEvent extends Event {

  const REFERRAL_ITEM_IDENTIFIED = 'urct.referral_item.identified';

  const REFERRAL_ITEM_FOR_TOKENS = 'urct.referral_item.for_cookie';

  /**
   * Referral item.
   * Same value as ReferralManager::referralItem
   *
   * @var \Drupal\urct\ReferralItem
   */
  protected $referralItem;

  /**
   * Constructs a referral item event.
   *
   * @param \Drupal\urct\ReferralItem $referral_item
   */
  public function __construct(ReferralItem $referral_item) {
    $this->referralItem = $referral_item;
  }

  /**
   * Get the referral item.
   *
   * @return \Drupal\urct\ReferralItem
   */
  public function getReferralItem() {
    return $this->referralItem;
  }

  /**
   * Get the referral item.
   *
   * @param \Drupal\urct\ReferralItem $referral_item
   *  Referral item object.
   */
  public function setReferralItem(ReferralItem $referral_item) {
    $this->referralItem = $referral_item;
  }
}