<?php

namespace Drupal\urct;

/**
 * To hold current referrer info.
 */
class ReferralItem {

  /**
   * Referrer code of the referrer.
   *
   * @var string
   */
  public $referral_id = NULL;

  /**
   * Referrer user ID.
   *
   * @var int
   */

  public $uid = NULL;

  /**
   * Referral type.
   *
   * @var string
   */
  public $type = NULL;

  /**
   * @var string
   */
  public $normal_path = NULL;

  /**
   * @var bool
   */
  public $referral_id_only =  FALSE;

  /**
   * This is valid only if we have enough data.
   */
  public function isValid() {
    return !empty($this->uid) && !empty($this->type) && !empty($this->referral_id);
  }
}