<?php

namespace Drupal\url_path_restrictions\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates that a URL alias does not match disallowed patterns.
 *
 * @Constraint(
 *   id = "DisallowedUrlPattern",
 *   label = @Translation("Disallowed URL pattern", context = "Validation"),
 *   type = "string"
 * )
 */
class DisallowedUrlPatternConstraint extends Constraint {

  /**
   * The message that will be shown if the value matches a disallowed pattern.
   */
  public string $message = 'The URL alias "@alias" matches a disallowed pattern "@pattern".';

}