# User Export CSV & VCF (user_export_csv_vcf)
 
**User Export CSV & VCF** module that enables administrators to export
selected user accounts as **CSV** or **VCF (vCard)** files directly
from the Users admin page (`/admin/people`).
It supports exporting **multiple users at once** using Drupal’s
default “User: Bulk operation” action system.
 
For a full description of the module, visit the
[project page](https://www.drupal.org/project/user_export_csv_vcf).
 
Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/user_export_csv_vcf).
 
## Table of contents
 
- Requirements
- Installation
- Configuration
- Similar Projects
- Features
- Maintainers
 
## Requirements
 
This module requires the following modules:
 
- [Phone number](https://www.drupal.org/project/phone_number)
- [Action](https://www.drupal.org/project/action)
  In Drupal 11, bulk actions have been moved to a contributed module.
 
## Installation
 
Install as you would normally install a contributed Drupal module.
For further information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).
Upon installation, the module creates Full name and Phone number
field in user profiles, then you need to visit people's page,
there you will get an option to download their User Export CSV and
VCF (Virtual Contact File) card under the operations dropdown.
This module provide single user and multi user csv/vcf export.
You can customize cards by editing user data. Ensure all required fields
are populated to avoid errors during card creation.
 
## Configuration
 
No Configuration is required.
 
## Similar Projects
 
While there are existing modules like Visiting Card (vcf),
our solution is ensuring compatibility with the latest versions and
providing modern features with export single and multi user as csv/vcf.
 
## Features
 
- Export selected users as a single `.csv` file
- Export selected users as a single `.vcf` file (multi-entry vCard)
- Uses Drupal core bulk action — no need for Views or additional contrib modules
- Supports exporting:
  - Full Name (`field_full_name`)
  - Phone Number (`field_phone_number`)
  - Email
  - Address (`field_address`)
  - Comment (`field_comment`)
  - User Picture (included in VCF as base64-encoded JPEG)
 
## Maintainers
 
- [Shaikh Sadab (shaikh-sadab)](https://www.drupal.org/u/shaikh-sadab)
- [Sanket Prajapati (sanketprajapati)](https://www.drupal.org/u/sanketprajapati)
