<?php

namespace Drupal\Tests\user_inactivity_revoke_roles\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\user\Entity\Role;
use Drupal\user\Entity\User;

/**
 * Test user_inactivity_revoke_roles functionality.
 *
 * @group user_inactivity_revoke_roles
 */
class UserInactivityRevokeRolesTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'user',
    'system',
    'user_inactivity_revoke_roles',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Install config & entity schema.
    $this->installEntitySchema('user');
    $this->installConfig(['user']);
    $this->installConfig(['user_inactivity_revoke_roles']);
  }

  /**
   * Test that roles are revoked passed the date.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function testRevokesInactiveUsers(): void {
    Role::create([
      'id' => 'editor',
      'label' => 'Editor',
    ]);

    // Force user 1 to exist.
    User::create([
      'name' => 'admin_user',
      'status' => 1,
    ])->save();

    // Create an inactive user (login 60 days ago).
    $user = User::create([
      'name' => 'inactive_user',
      'status' => 1,
      'roles' => ['editor'],
      'access' => \Drupal::time()->getCurrentTime() - (60 * 24 * 60 * 60),
    ]);
    $user->save();

    \Drupal::configFactory()->getEditable('user_inactivity_revoke_roles.settings')
      ->set('revoke_enabled', TRUE)
      ->set('user_revoke_roles', [
        'editor' => 2592000 - 10,
      ])
      ->save();

    user_inactivity_revoke_roles_cron();

    $user = User::load($user->id());
    // Assert role was removed.
    $this->assertFalse($user->hasRole('editor'), 'Role "editor" revoked from inactive user.');
  }

}
