<?php

namespace Drupal\Tests\user_inactivity_revoke_roles\Kernel;

use Drupal\Core\Render\BubbleableMetadata;
use Drupal\KernelTests\KernelTestBase;
use Drupal\user\Entity\Role;
use Drupal\user\Entity\User;

/**
 * Test user_inactivity_revoke_roles token functionality.
 *
 * @group user_inactivity_revoke_roles
 */
class UserInactivityTokenTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'user',
    'system',
    'user_inactivity_revoke_roles',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Install config & entity schema.
    $this->installEntitySchema('user');
    $this->installConfig(['user']);
    $this->installConfig(['user_inactivity_revoke_roles']);
  }

  /**
   * Test the token for uirr_role_removed.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function testRoleRemovedToken(): void {
    Role::create([
      'id' => 'editor',
      'label' => 'Editor',
    ])->save();

    $user = User::create([
      'name' => 'Editor',
    ]);

    $type = 'user';
    $tokens = [
      'name' => '[site:name]',
      'uirr_role_removed' => '[user:uirr_role_removed]',
      'login-url' => '[site:login-url]',
    ];
    $data = [
      'user' => $user,
    ];
    $options = [
      'langcode' => 'en',
      'callback' => 'user_mail_tokens',
      'clear' => TRUE,
      'rid' => 'editor',
    ];
    $bubbleable_metadata = new BubbleableMetadata();

    $replacements = user_inactivity_revoke_roles_tokens($type, $tokens, $data, $options, $bubbleable_metadata);

    $this->assertNotEmpty($replacements);
    $this->assertEquals('Editor', $replacements['[user:uirr_role_removed]']);
  }

}
