<?php

namespace Drupal\user_login_tracker\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Login Tracker settings.
 */
class LoginTrackerSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['user_login_tracker.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'user_login_tracker_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['general'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('General Settings'),
    ];

    $form['general']['description'] = [
      '#markup' => $this->t('Configure the Login Tracker module here.'),
    ];

    $form['general']['enable_tracking'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable login tracking'),
      '#default_value' => $this->config('user_login_tracker.settings')->get('enable_tracking'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Store the settings.
    $this->config('user_login_tracker.settings')
      ->set('enable_tracking', $form_state->getValue('enable_tracking'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
