<?php

namespace Drupal\user_login_tracker\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Database\Database;
use Drupal\user\Entity\User;

/**
 * Provides a 'Login Tracker' block.
 *
 * @Block(
 *   id = "user_login_tracker_block",
 *   admin_label = @Translation("Login Tracker Block"),
 *   category = @Translation("Custom")
 * )
 */
class LoginTrackerBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $current_date = \Drupal::service('date.formatter')->format(time(), 'custom', 'Y-m-d');

    // Query the database to get the number of logins.
    $database = Database::getConnection();
    $query = $database->select('user_login_tracker', 'lt');
    $query->fields('lt', ['uid']);
    $query->condition('lt.login_date', $current_date);
    $query->groupBy('lt.uid');
    $query->addExpression('COUNT(lt.uid)', 'login_count');
    $results = $query->execute();

    // Prepare output to display the login count for each user.
    $output = [];
    foreach ($results as $row) {
      $user = User::load($row->uid);

      $output[] = $this->t('User @name logged in @count times', [
        '@name' => $user ? $user->get('name')->value : $this->t('Unknown User'),
        '@count' => $row->login_count,
      ]);
    }

    return [
      '#theme' => 'item_list',
      '#items' => $output,
      '#title' => $this->t('User Login Counts'),
      '#cache' => [
        'max-age' => 0,
      ],
    ];
  }

}
