<?php

namespace Drupal\user_logout;

use Drupal\Core\Session\SessionManagerInterface;

/**
 * Methods for running the UserLogout in a batch.
 */
class UserLogoutBatch {

  /**
   * Processes the user logout.
   *
   * @param \Drupal\Core\Session\SessionManagerInterface $session_manager
   *   The session manager service.
   * @param int $uid
   *   User ID.
   * @param array $context
   *   The batch context.
   */
  public static function process(SessionManagerInterface $session_manager, $uid, &$context): void {
    $session_manager->delete($uid);
  }

  /**
   * Finish batch.
   *
   * @param bool $success
   *   Indicate that the batch API tasks were all completed successfully.
   * @param array $results
   *   An array of all the results that were updated in update_do_one().
   * @param array $operations
   *   A list of the operations that had not been completed by the batch API.
   */
  public static function finish($success, $results, $operations): void {
    $messenger = \Drupal::messenger();
    if ($success) {
      $messenger->addStatus(t('The selected users were logged out successfully.'));
    }
    else {
      // An error occurred.
      // $operations contains the operations that remained unprocessed.
      $error_operation = reset($operations);
      $t_args = [
        '%error_operation' => $error_operation[0],
        '@arguments' => print_r($error_operation[1], TRUE),
      ];
      $message = t('An error occurred while processing %error_operation with arguments: @arguments', $t_args);
      $messenger->addError($message);
    }
  }

}
