<?php

namespace Drupal\user_mailman_register\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns subscription status text for a given status code.
 *
 * The constant definitions of this class are defined in
 * user_mailman_register.module.
 */
class StatusController extends ControllerBase {

  /**
   * Subscriptions status: unsubscribed.
   */
  const USER_MAILMAN_REGISTER_UNSUBSCRIBED = 0;

  /**
   * Subscriptions status: subscribed but temporarily disabled.
   */
  const USER_MAILMAN_REGISTER_SUBSCRIBED_DISABLED = 1;

  /**
   * Subscriptions status: subscribed, receive digests.
   */
  const USER_MAILMAN_REGISTER_SUBSCRIBED_DIGEST = 2;

  /**
   * Subscriptions status: subscribed, normal delivery.
   */
  const USER_MAILMAN_REGISTER_SUBSCRIBED_NORMAL = 3;

  /**
   * An array with subscription status codes as keys and labels as values.
   *
   * @var array
   */
  protected static $statuses;

  /**
   * Returns a list of subscription statuses.
   *
   * @return array
   *   Array of the possible subscription statuses.
   */
  public static function getStatuses() {
    if (!static::$statuses) {
      static::$statuses = [
        static::USER_MAILMAN_REGISTER_SUBSCRIBED_DISABLED
        => t('No mail (temporarily disable delivery)'),
        static::USER_MAILMAN_REGISTER_SUBSCRIBED_DIGEST
        => t('Subscribe for digest (receive emails in a bundle)'),
        static::USER_MAILMAN_REGISTER_SUBSCRIBED_NORMAL
        => t('Subscribe for all mail (normal delivery)'),
        static::USER_MAILMAN_REGISTER_UNSUBSCRIBED
        => t('Unsubscribed'),
      ];
    }

    return static::$statuses;
  }

}
