<?php

namespace Drupal\user_mailman_register_import\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for importing Mailman mailing lists.
 */
class UserMailmanRegisterImportForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'user_mailman_register_import_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $lists = _user_mailman_register_get_lists();
    $options = [];
    foreach ($lists as $list) {
      $options[$list['lid']] = $list['name'];
    }

    $form['#attributes'] = ["enctype" => "multipart/form-data"];

    $form['import'] = [
      '#type' => 'fieldset',
      '#field_prefix' => t('<p>This module is EXPERIMENTAL. <strong>Make a backup of the <em>mailman_users</em> table</strong> before using it. A backup of the whole drupal database is also recommended. The module will remove all existing entries in the mailman_users table for a epecified list, and replace them with the list ID, status, email address, Mailman password, and moderation bit from the Mailman server, setting lchecktime to now. <em>Before importing, be sure the target list has been created and permissions set appropriately.</em></p><p>To make a valid file to import in this form, you MUST have a shell access with mailman or greater user permission to your Mailman server. Redirect into a new file the output of the mailman <em>dumpdb</em> utility executed using the pck config file of your list as command line argument. For example, in Linux Debian, it should be something like this: <code>/var/lib/mailman/bin/dumpdb /var/lib/mailman/lists/YOUR_LIST/config.pck > mailman.db</code></p><p>The filename can be anything but the *.db extension is required.</p>'),

    ];

    $form['import']['lists'] = [
      '#type' => 'select',
      '#title' => t('List'),
      '#description' => t('Select the list to syncronize with the dump file.'),
      '#required' => TRUE,
      '#options' => $options,
    ];

    $form['import']['file_upload'] = [
      '#type' => 'file',
      '#title' => t('File'),
      '#size' => 40,
      '#description' => t('The mailman dumpdb file.'),
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => t('Import'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    if ($form_state->getValue(['lists']) == 0) {
      $form_state->setErrorByName('lists', t('You must select a valid list.'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $validators = ['file_validate_extensions' => ['db']];
    if (!$file = file_save_upload('file_upload', $validators)) {
      $form_state->setErrorByName('file_upload', t("Failed to save the file."));
    }
    else {
      // dump($file);
      // exit;
      $data = file_get_contents($file[0]->getFileUri());
      if (!_user_mailman_register_import_fileprocess($file[0]->getFileUri(), $form_state->getValue(['lists']))) {
        $form_state->setErrorByName('file_upload', t("There was an error processing the file."));
      }
      $file_id = $file[0]->id();
      \Drupal::service('entity_type.manager')->getStorage('file')->load($file_id)->delete();
    }
  }

}
