<?php

namespace Drupal\user_mailman_register\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Views field plugin to convert subscription status value to text.
 *
 * @ViewsField("lstatus")
 */
class Status extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $lstatus_value = $this->getValue($values);
    // Convert subscription status value to text equivalent.
    switch ($lstatus_value) {
      case 0:
        $lstatus_text = t('Unsubscribed');
        break;

      case 1:
        $lstatus_text = t('No mail (temporarily disable delivery)');
        break;

      case 2:
        $lstatus_text = t('Subscribe for digest (receive emails in a bundle)');
        break;

      case 3:
        $lstatus_text = t('Subscribe for all mail (normal delivery)');
        break;
    }
    return $lstatus_text;
  }

}
