<?php

namespace Drupal\user_mailman_register\Form;

use Drupal\Core\Form\FormInterface;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * @file
 * Contains \Drupal\user_mailman_register\Form\AdminListForm.
 */

/**
 * Provides a form that shows existing lists with a link to add a new one.
 */
class AdminListForm implements FormInterface {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'user_mailman_register_adminlist_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, $form_state) {
    $urladd = Url::fromRoute('user_mailman_register.add_list', [], ['query' => \Drupal::destination()->getAsArray()]);
    $form['add_new'] = [
      '#type' => 'markup',
      '#prefix' => '<p>&raquo; ',
      '#markup' => Link::fromTextAndUrl(t('Add new mailing list'), $urladd)->toString(),
      '#suffix' => '</p>',
    ];
    $header = [
      ['data' => t('ID'), 'field' => 'lid', 'sort' => 'asc'],
      ['data' => t('Name'), 'field' => 'name'],
      ['data' => t('User invite'), 'field' => 'user_invite'],
      ['data' => t('User notify'), 'field' => 'user_notify'],
      ['data' => t('List admins notify'), 'field' => 'user_admin_notify'],
      ['data' => t('Allow unsub'), 'field' => 'allow_unsubscribe'],
      ['data' => t('Allow temp disable'), 'field' => 'allow_temp_disable'],
      ['data' => t('Allow digest'), 'field' => 'allow_digest'],
      ['data' => t('Default new reg'), 'field' => 'defaultnewreg'],
      ['data' => t('Role sync'), 'field' => 'role_sync'],
      ['data' => t('Actions')],
    ];
    $rows = [];
    $database = \Drupal::database();
    $query = $database->select('mailman_lists', 'ml')
      ->extend('Drupal\Core\Database\Query\PagerSelectExtender')
      ->extend('Drupal\Core\Database\Query\TableSortExtender');
    $query
      ->fields('ml', [
        'lid',
        'name',
        'user_invite',
        'user_notify',
        'user_admin_notify',
        'allow_unsubscribe',
        'allow_temp_disable',
        'allow_digest',
        'defaultnewreg',
        'role_sync',
        'webadmin',
        'webpass',
      ])
      ->orderByHeader($header);
    $count_query = $query->countQuery();
    $query->setCountQuery($count_query);
    $result = $query->execute();
    foreach ($result as $list) {
      $row = (array) $list;
      unset($row['webadmin']);
      unset($row['webpass']);
      $account = \Drupal::currentUser();
      $cmd = _user_mailman_register_allowed_list($list, $account) ? t('Edit') : t('Activate');
      $cmd = $cmd->__toString();
      $urledit = Link::createFromRoute(t('@cmd', ['@cmd' => $cmd]), 'user_mailman_register.edit_list', ['list' => $list->lid], ['query' => \Drupal::destination()->getAsArray()])->toString();
      $urldelete = Link::createFromRoute(t('Delete'), 'user_mailman_register.delete_list', ['list' => $list->lid], ['query' => \Drupal::destination()->getAsArray()])->toString();
      $urlactions = ['#markup' => $urledit . '<br>' . $urldelete];
      $row['Actions'] = \Drupal::service('renderer')->render($urlactions);
      $rows[] = $row;
    }
    $form['mailing_lists'] = [
      '#theme' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => t('There are no mailing lists configured.'),
    ];
    $form['mailing_lists_pager'] = ['#type' => 'pager'];
    $form['num_lists'] = [
      '#type' => 'hidden',
      '#value' => $count_query->execute()->fetchField(),
    ];

    return $form;

  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, $form_state) {
  }

}
