<?php

namespace Drupal\user_mailman_register;

/**
 * Provides dynamic title for the user mailman register module JoinListForm.
 */
class JoinListTitle {

  /**
   * Returns a page title.
   */
  public function joinList($user = 0) {
    $account = \Drupal::entityTypeManager()->getStorage('user')->load($user);
    if (isset($account)) {
      $name = $account->name->value;
      if (isset($user)) {
        if ($user > 0) {
          return t('Mailing lists for %name', ['%name' => $name]);
        }
        else {
          return t('Mailing lists');
        }
      }
    }
  }

}
