<?php

namespace Drupal\user_mailman_register;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides dynamic permissions for the user mailman register module.
 */
class Permissions implements ContainerInjectionInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a new EntityPermissions object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager')
    );
  }

  /**
   * Fetches permissions for user mailman register lists.
   */

  public function permissions() {
    $permissions = [];
    $lists = [];
    $database = \Drupal::database();
    $result = $database->query("SELECT * FROM mailman_lists ORDER BY name");
    foreach ($result as $obj) {
      $lists[] = (array) $obj;
    }
    if (!empty($lists)) {
      foreach ($lists as $list) {
        $filter = '![^abcdefghijklmnopqrstuvwxyz0-9-_ ]+!s';
        $list_clean = preg_replace($filter, '-', mb_strtolower(($list['name'])));
        $permissions['can subscribe to ' . $list_clean] = [
          'title' => t('Can subscribe to @list_clean', ['@list_clean' => $list_clean]),
          'description' => t('Allows the user to subscribe to the @list_clean mailing list', ['@list_clean' => $list_clean]),
        ];
      }
    }
    return $permissions;
  }

}
