<?php

namespace Drupal\user_mailman_register\Plugin\views\filter;

use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\views\Plugin\views\filter\InOperator;
use Drupal\views\ViewExecutable;

/**
 * Filters by description field of Mailman list.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("user_mailman_register_list_descriptions")
 */
class ListDescriptions extends InOperator {

  /**
   * {@inheritdoc}
   */
  public function init(ViewExecutable $view, DisplayPluginBase $display, array &$options = NULL) {
    parent::init($view, $display, $options);
    $this->valueTitle = t('List name');
    $this->definition['options callback'] = [$this, 'generateOptions'];
  }

  /**
   * Override the query so that no filtering takes place no options selected.
   */
  public function query() {
    if (!empty($this->value)) {
      parent::query();
    }
  }

  /**
   * Skip validation if no options are chosen so we can use it as a non-filter.
   */
  public function validate() {
    if (!empty($this->value)) {
      parent::validate();
    }
  }

  /**
   * Helper function that generates the options.
   *
   * @return array
   *   List of available lists.
   */
  public function generateOptions() {
    $database = \Drupal::database();
    $query = $database->query("SELECT DISTINCT lid, name, description FROM {mailman_lists} ORDER BY name");
    $result = $query->fetchAll();
    if ($result) {
      foreach ($result as $list) {
        $lists[$list->description] = $list->name;
      }
    }
    else {
      $lists[] = "None found";
    }
    return $lists;
  }

}
