<?php

/**
 * @file
 * Contains Mailman list subscriptions view.
 */

/**
 * Implements hook_views_data().
 */
function user_mailman_register_views_data() {

  $data = [];
  $data['mailman_users'] = [];
  $data['mailman_users']['table'] = [
    'group' => t('User Mailman Register users'),
    'base' => [
      // Primary key, required for base tables.
      'field' => 'uid',
      'title' => t('Mailman users'),
      'help' => t('Mailman discussion list subscribers.'),
    ],
  ];
  $data['mailman_users']['table']['provider'] = 'user_mailman_register';
  $data['mailman_lists']['table'] = [
    'title' => t('Mailman lists'),
    'group' => t('User Mailman Register lists'),
    // Join to the base table of 'mailman_users'.
    'join' => [
      'mailman_users' => [
        // Column from 'mailman_users' that will be used in the join.
        'left_field' => 'lid',
        // Column from 'mailman_lists' that will be used in the join.
        'field' => 'lid',
      ],
    ],
  ];

  $data['mailman_lists']['table']['provider'] = 'user_mailman_register';

  // Make the 'mailman_users' field 'uid' available to Views.
  $data['mailman_users']['uid'] = [
    'title' => t('User ID'),
    'help' => t('Mailman discussion list subscriber ID.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'standard',
    ],
  ];

  // Make the 'mailman_users' field 'lstatus' available to Views.
  $data['mailman_users']['lstatus'] = [
    'title' => t('Subscription status'),
    'help' => t('Mailman discussion list subscription status.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'lstatus',
    ],
    // Declare to Views that this column can be filtered on.
    'filter' => [
      // Views plugin to be used for this filter.
      'id' => 'in_operator',
      'options callback' => 'Drupal\user_mailman_register\Controller\StatusController::getStatuses',
    ],
  ];

  // Make the 'mailman_users' field 'lmail' available to Views.
  $data['mailman_users']['lmail'] = [
    'title' => t('Current user subscribed email'),
    'help' => t('Mailman discussion list current user subscribed email.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'standard',
    ],
  ];

  // Make the 'mailman_users' field 'lchecktime' available to Views.
  $data['mailman_users']['lchecktime'] = [
    'title' => t('Last Mailman subscription check time'),
    'help' => t('Mailman discussion list last subscription check time.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'date',
    ],
  ];

  // Make the 'mailman_users' field 'lmod' available to Views.
  $data['mailman_users']['lmod'] = [
    'title' => t('Moderation flag'),
    'help' => t('Mailman discussion list subscriber moderation flag.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'boolean',
    ],
  ];

  // Make the 'mailman_lists' field 'description' available to Views.
  $data['mailman_lists']['description'] = [
    'title' => t('List description'),
    'help' => t('Mailman discussion list description.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'standard',
    ],
  ];

  // Introduce a 'virtual' Views column called 'drupal_user_id' within the
  // 'mailman_users' table and place the relationship of "uid" into it.
  $data['mailman_users']['drupal_user_id'] = [
    'title' => t('Drupal user ID'),
    'help' => t('Mailman discussion list Drupal user ID.'),
    'relationship' => [
      'id' => 'standard',
      // Our relationship points to the 'users_field_data' base table.
      'base' => 'users_field_data',
      // Since this relationship belongs to a 'virtual' column
      // 'drupal_user_id', we now have to specify the real database
      // column it should operate against. Whenever 'real field' is missing
      // among the definition items, Views module assumes the Views column
      // matches the actual DB column name. Whenever we are using 'virtual'
      // Views columns, we then must specify the key 'real field'.
      'real field' => 'uid',
      'label' => t('Drupal user'),
    ],
    // Declare to Views that this column can be filtered on.
    'filter' => [
      // Views plugin to be used for this filter.
      'id' => 'string',
    ],
  ];

  // Make the 'mailman_lists' field 'name' available to Views.
  $data['mailman_lists']['name'] = [
    'title' => t('List name'),
    'help' => t('Mailman discussion list name.'),
    'field' => [
      // Views field plugin responsible for operating this field's column.
      'id' => 'standard',
    ],
    // Declare to Views that this column can be filtered on.
    'filter' => [
      'title' => t('Mailman lists'),
      'help' => t('Specify the Mailman list to be searched.'),
      'field' => 'description',
      // Views plugin to be used for this filter.
      'id' => 'user_mailman_register_list_descriptions',
    ],
  ];

  return $data;

}
