<?php
function user_mailman_register_views_data() {
  $data['mailman_lists']['table']['group'] = t('User Mailman Register Lists');
  $data['mailman_lists']['table']['join']['users'] = array(
    'left_table' => 'mailman_users',
    'left_field' => 'lid',
    'field' => 'lid',
    'type' => 'INNER',
  );

    // defined in mailman_manager.views.inc
//   $data['mailman_lists']['name'] = array(
//     'title' => t('Mailing List name'),
//     'help' => t('Mailing List name'),
//     'field' => array(
//         'handler' => 'views_handler_field',
//     ),
//     'sort' => array(
//        'handler' => 'views_handler_sort',
//      ),
//     'filter' => array(
//         'handler' => 'user_mailman_register_handler_filter_listname',
//     ),
//   );
  
  $data['mailman_lists']['description'] = array(
    'title' => t('Description'),
    'help' => t('A brief description of this mailing list. This text will be displayed in the subscriptions page.'),
    'field' => array(
        'handler' => 'views_handler_field',
    ),
    'filter' => array(
        'handler' => 'views_handler_filter_string',
    ),
  );
  
    // defined in mailman_manager.views.inc
//   $data['mailman_lists']['command'] = array(
//     'title' => t('Command'),
//     'help' => t("Mailing List 'request' address"),
//     'field' => array(
//      'handler' => 'user_mailman_register_handler_field_mail',
//      'click sortable' => TRUE,
//      ),
//      'sort' => array(
//        'handler' => 'views_handler_sort',
//      ),
//      'filter' => array(
//        'handler' => 'views_handler_filter_string',
//      ),
//   );
  
    // defined in mailman_manager.views.inc
//   $data['mailman_lists']['admin'] = array(
//     'title' => t('Admin'),
//     'help' => t("Mailing List 'admin' address"),
//     'field' => array(
//      'handler' => 'user_mailman_register_handler_field_mail',
//      'click sortable' => TRUE,
//      ),
//      'sort' => array(
//        'handler' => 'views_handler_sort',
//      ),
//      'filter' => array(
//        'handler' => 'views_handler_filter_string',
//      ),
//   );
  
  $data['mailman_lists']['webarch'] = array(
    'title' => t('Archive'),
    'help' => t("Mailing list web archive address for users"),
    'field' => array(
     'handler' => 'views_handler_field_url',
     'click sortable' => TRUE,
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_string',
     ),
  );
  
  $data['mailman_lists']['webadmin'] = array(
    'title' => t('Admin web page'),
    'help' => t('Admin web page'),
    'field' => array(
     'handler' => 'views_handler_field_url',
     'click sortable' => TRUE,
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_string',
     ),
  );
  
  $data['mailman_lists']['user_invite'] = array(
    'title' => t('Only invite users'),
    'help' => t('Just invite new users instead of subscribing them?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
    
  $data['mailman_lists']['user_notify'] = array(
    'title' => t('Notify users'),
    'help' => t('Send welcome messages to the new subscribee?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
    
  $data['mailman_lists']['user_admin_notify'] = array(
    'title' => t('Notify mailman administrators'),
    'help' => t('Send notifications of new subscription to the list owner?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
   
   $data['mailman_lists']['allow_unsubscribe'] = array(
    'title' => t('Allow unsubscribe'),
    'help' => t('Allow unsubscribe'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
  
  $data['mailman_lists']['allow_temp_disable'] = array(
    'title' => t('Allow temporary disable'),
    'help' => t('Allow users to temporarily disable delivery?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
   
  $data['mailman_lists']['allow_digest'] = array(
    'title' => t('Allow digest'),
    'help' => t('Allow users to subscribe in digest mode?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
   
  $data['mailman_lists']['defaultnewreg'] = array(
    'title' => t('Default choice'),
    'help' => t('This will be the default choice in the user subscription form.'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
   
  $data['mailman_lists']['role_sync'] = array(
    'title' => t('Sync with roles'),
    'help' => t('Just invite new users instead of subscribing them?'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );

  $data['mailman_users']['table']['group'] = t('User Mailman Register Subscribers');
  $data['mailman_users']['table']['join']['users'] = array(
    'left_field' => 'uid',
    'field' => 'uid',
    'type' => 'INNER',
  );

  $data['mailman_users']['uid'] = array(
    'title' => t('User Uid'),
    'help' => t('Users'),
    'field' => array(
      'title' => t('Subscription page'),
      'help' => t('The user subscription page'),
      'handler' => 'user_mailman_register_handler_field_subscription_link',
      'click sortable' => TRUE,
    ),
    'relationship' => array(
      'base' => 'users',
      'field' => 'uid',
      'handler' => 'views_handler_relationship',
      'label' => t('User relationship'),
    ),
  );

  $data['mailman_users']['lmail'] = array(
    'title' => t('Subscribed email'),
    'help' => t('User subscribed email'),
    'field' => array(
      'handler' => 'views_handler_field_user_mail',
      'click sortable' => TRUE,
    ),
    'sort' => array(
      'handler' => 'views_handler_sort',
    ),
    'filter' => array(
      'handler' => 'views_handler_filter_string',
    ),
  );
  
  $data['mailman_users']['lmod'] = array(
    'title' => t('Moderated'),
    'help' => t('User is moderated'),
    'field' => array(
       'handler' => 'views_handler_field_boolean',
       'click sortable' => TRUE,
     ),
     'filter' => array(
       'handler' => 'views_handler_filter_boolean_operator',
       'label' => t('Published'),
       'type' => 'yes-no',
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
  );
  
  $data['mailman_users']['lchecktime'] = array(
    'title' => t('Last sync'),
    'help' => t('The last time that subscription was syncronized with mailman'),
    'field' => array(
        'handler' => 'views_handler_field_date',
    ),
    'filter' => array(
        'handler' => 'views_handler_filter_date',
    ),
    'sort' => array(
        'handler' => 'views_handler_sort_date',
    ),
  );
  
  $data['mailman_users']['lstatus'] = array(
    'title' => t('Subscription status'),
    'help'  => t('The stored subscription status of the user'),
    'field' => array(
     'handler' => 'user_mailman_register_handler_field_subscription_status',
     'click sortable' => TRUE,
     ),
     'sort' => array(
       'handler' => 'views_handler_sort',
     ),
     'filter' => array(
       'handler' => 'user_mailman_register_handler_filter_subscription_status',
     ),
  );

return $data; 
}

/**
 * Implementation of hook_views_handlers().
 */
function user_mailman_register_views_handlers() {
  return array(
    'info' => array(
      'path' => drupal_get_path('module', 'user_mailman_register') . '/includes',
    ),
    'handlers' => array(
      // field handlers
      'user_mailman_register_handler_field_mail' => array(
        'parent' => 'views_handler_field',
      ),
      'user_mailman_register_handler_field_subscription_link' =>array(
        'parent' => 'views_handler_field_user_link',
      ),
        'user_mailman_register_handler_field_subscription_status' => array(
        'parent' => 'views_handler_field',
      ),
        'user_mailman_register_handler_filter_subscription_status' => array(
        'parent' => 'views_handler_filter_in_operator',
      ),
        'user_mailman_register_handler_filter_listname' => array(
        'parent' => 'views_handler_filter_many_to_one',
      ),
    ),
  );
}
