# User Preference Login Redirect

The User Preference Login Redirect module allows users to select a custom redirect destination (route) after logging in.

Administrators can configure a list of available routes and their labels via the module settings. Users can then choose their preferred redirect from their profile settings.

**Features**

- **Configurable Login Redirect Routes:** Define available routes and labels in the module settings.
- **User Profile Setting:** Users can select their preferred redirect destination on their profile page.
- **Automatic Login Redirect:** (If no `?destination` parameter is present) Users are redirected to their chosen route after login.
- **Permissions:** Functionality can be limited to certain roles.

**Use Case**

This module is useful for sites where users frequently need to navigate to specific pages after login, improving usability and workflow efficiency.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/user_preference_login_redirect).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/user_preference_login_redirect).

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Enable the module at Administration > Extend.
2. Navigate to Administration > Configuration > People > User preference login redirect settings (`/admin/config/people/user-preference-login-redirect`).
3. Configure the list of available routes and their labels.
4. Grant the "Select login redirect preference in user profile" permission to the desired user roles.
5. Grant the "Administer User preference login redirect settings" permission to administrator roles.
6. Users can now visit their profile edit page to select their preferred redirect destination.

## Drush Commands

### Bulk Update User Redirect Preferences

Set all users' redirect preference to a specific route defined in the "User
preference login redirect settings"

```bash
drush user_preference_login_redirect:bulk-update <route>
# or use the alias
drush uplr-bu <route>
```

**Arguments:**
- `route` - The route key or label to set for all users.

**Examples:**

```bash
# Set all users to redirect to a specific route:
drush uplr-bu system.performance_settings

# Set all users to redirect to a route by its label
drush uplr-bu "My Dashboard"
```

NOTE, that the route / route label needs to be set under the "User preference
login redirect settings" "Available redirect routes" config first!
