<?php

declare(strict_types=1);

namespace Drupal\user_preference_login_redirect;

/**
 * Service for parsing route configurations.
 */
class RouteParser {

  /**
   * Parse routes from configuration text.
   *
   * @param string $routes_text
   *   The routes text from configuration.
   *
   * @return array
   *   An array of routes keyed by route name with labels as values.
   */
  public function parseRoutes(string $routes_text): array {
    $routes = [];
    $lines = array_filter(array_map('trim', explode("\n", $routes_text)));

    foreach ($lines as $line) {
      if (str_contains($line, '|')) {
        [$route, $label] = array_map('trim', explode('|', $line, 2));
        if (empty($route) && empty($label)) {
          continue;
        }
        $routes[$route] = $label;
      }
    }

    return $routes;
  }

}
